<?php

namespace Database\Factories;

use App\Helpers\Media;
use Illuminate\Database\Eloquent\Factories\Factory;

/**
 * @extends \Illuminate\Database\Eloquent\Factories\Factory<\App\Models\AboutStruc>
 */
class AboutStrucFactory extends Factory
{
    /**
     * Define the model's default state.
     *
     * @return array<string, mixed>
     */
    public function definition(): array
    {
          // 1. Create a fake uploaded file
          $imageFile = Media::generateFakeUploadedFile(
            prefix: 'aboutStrucs',
            extension: 'webp'
        );
        // 2. Use your existing Media helper (exactly as you have it) 
        $imageName = Media::uploadAndAttachImage($imageFile, 'aboutStrucs')?? null;
        
        return [
            'name_en' => fake()->words(2,true),
            'name_ar' => fake()->words(2,true),
            'text_en' => fake()->sentence(),
            'text_ar' => fake()->sentence(),
            'image'   => $imageName,
            'order'   => fake()->numberBetween(1, 10),
            'status'  => fake()->boolean(70),


        ];
    }
}
