<?php

namespace App\Traits;

use App\Models\SeoAssistant;
use Melbahja\Seo\Schema;
use Melbahja\Seo\Schema\Thing;
use Melbahja\Seo\MetaTags;
use App\Models\About;
use App\Models\Brand;
use DateTime;
use App\Models\BlogItem;
use Mcamara\LaravelLocalization\Facades\LaravelLocalization;

trait SeoTrait
{


    public function ISoDateTimeFormate($date)
    {
        $datetime = new DateTime($date);
        return $datetime->format(DateTime::ATOM) . 'Z'; // Updated ISO8601
    }

    ////////home page/////
    public function homePageSeo()
    {
        $lang = LaravelLocalization::getCurrentLocale();
        $seo = SeoAssistant::first();

        if (!$seo) {
            $seo =  SeoAssistant::create([]);
        }


        $schema1 = new Thing('LocalBusiness', [
            'name'          => config('site_app_name'),
            'url'          => LaravelLocalization::localizeUrl('/'),
            'image'         => config('site_logo'),
            'telephone' => config('site_mobile'),
            'address' => config('site_address1') ?? 'no address found !',
        ]);


        $schema2 = new Thing('Organization', [
            'url'          => LaravelLocalization::localizeUrl('/'),
            'logo'         => config('site_logo'),
            'contactPoint' => new Thing('ContactPoint', [
                'telephone' => config('site_mobile'),
                'contactType' => 'customer service'
            ]),
        ]);

        $schema = new Schema(
            $schema1,
            $schema2
        );

        $metatags = new MetaTags();

        $metatags
            ->title($seo->home_page_meta_title ?? config('site_app_name'))
            ->meta('title', $seo->home_page_meta_title ?? config('site_app_name'))
            ->description($seo->home_page_meta_desc ?? strip_tags(config('site_site_description')))
            ->meta('author', config('site_app_name'))
            ->image(config('site_logo'))
            ->mobile(LaravelLocalization::localizeUrl('/'))
            ->canonical(LaravelLocalization::localizeUrl('/'))
            ->shortlink(LaravelLocalization::localizeUrl('/'))
            ->meta('robots', ($seo->home_meta_robots) ? 'index' : 'noindex');

        return [$schema, $metatags];
    }
    // Categories page //
    public function categoriesPageSeo()
    {
        $lang = LaravelLocalization::getCurrentLocale();

        $seo = SeoAssistant::first();
        $metatags = new MetaTags();
        $about = About::first();

        $metatags
            ->title($seo->categories_meta_title ?? config('site_app_name'))
            ->meta('title', $seo->categories_meta_title ?? config('site_app_name'))
            ->description($seo->categories_meta_desc ?? strip_tags(config('site_site_description')))
            ->meta('author', config('site_app_name'))
            ->image(config('site_logo'))
            ->mobile(route('website.categories'))
            ->canonical(route('website.categories'))
            ->shortlink(route('website.categories'))
            ->meta('robots', ($seo->categories_index) ? 'index' : 'noindex');

        $schema = new Schema(
            new Thing('Article', [
                'url' => route('website.categories'),
                'image' => config('site_logo'),
                'headline' => $seo->categories_meta_title ?? config('site_app_name'),
                'author' => new Thing('author', [
                    'name' => config('site_app_name'),
                    'url' => route('website.categories'),
                ]),

                'datePublished' => $this->ISoDateTimeFormate($about->created_at),
                'dateModified' => $this->ISoDateTimeFormate($about->updated_at),
            ])
        );
        return [$schema, $metatags];
    }

    public function categoryPageSeo($category)
    {
       
        $metatags = new MetaTags();
 
        $metatags
            ->title($category->meta_title ?? $category->name ?? '')
            ->meta('title', $category->meta_title ?? $category->name ?? '')
            ->description($category->meta_description ?? $category->text ?? '')
            ->meta('author', config('site_app_name'))
            ->meta('time', date('D M j G:i:s T Y', strtotime($category->created_at)))
            ->image($category->image_path)
            ->mobile(route('website.category.products', $category->link))
            ->canonical(route('website.category.products', $category->link))
            ->shortlink(route('website.category.products', $category->link))
            ->meta('robots', ($category->index) ? 'index' : 'noindex');

        $schema = new Schema(
            new Thing('Article', [
                'url' => route('website.category.products', $category->link),
                'image' => $category->image_path ?? config('site_logo'),
                'headline' => $category->meta_title ??  config('site_app_name'),
                'author' => new Thing('author', [
                    'name' => config('site_app_name'),
                    'url' => route('website.category.products', $category->link),
                ]),
                'datePublished' => now()->toIso8601String(),
                'dateModified' => now()->toIso8601String(),
            ])
        );

        return [$schema, $metatags];
    }

    public function productsPageSeo()
    {
        $seo = SeoAssistant::first();
        $metatags = new MetaTags();

        $metatags
            ->title($seo->products_meta_title ?? config('site_app_name'))
            ->meta('title', $seo->products_meta_title ?? config('site_app_name'))
            ->description($seo->products_meta_desc ?? strip_tags(config('site_about_app')))
            ->meta('author', config('site_app_name'))
            ->image(config('site_logo'))
            ->mobile(route('products'))
            ->canonical(route('products'))
            ->shortlink(route('products'))
            ->meta('robots', ($seo->products_meta_robots) ? 'index' : 'noindex')
            ->meta('time', now()->toIso8601String());

        $schema = new Schema(
            new Thing('Article', [
                'url' => route('products'),
                'image' => config('site_logo'),
                'headline' => (config('site_app_name')),
                'author' => new Thing('author', [
                    'name' => config('site_app_name'),
                    'url' => route('products'),
                ]),

                'datePublished' => now()->toIso8601String(),
                'dateModified' => now()->toIso8601String(),
            ])
        );
        return [$schema, $metatags];
    }

    public function productPageSeo($product)
    {

        $seo = SeoAssistant::first();

        // Main Product Schema
        $productSchema = new Thing('Product', [
            '@id' => route('product.details', $product->link),
            'name' => $product->name,
            'description' => $product->short_text,
            'code' => $product->code ?: 'not-available',
            'url' => route('product.details', $product->link),
            'image' => $product->has_variants ? $product->defaultVariant->first_image : $product->main_image_path,

            'offers' => new Thing('Offer', [
                '@type' => 'Offer',
                'url' => route('product.details', $product->link),
                'priceCurrency' => config('site_currency'),
                'price' =>  $product->getEffectivePrice(),
                'priceValidUntil' => now()->addYear()->format('Y-m-d'),
                'itemCondition' => 'https://schema.org/NewCondition',
                'availability' => ($product->getAvailableStock() > 0)
                    ? 'https://schema.org/InStock'
                    : 'https://schema.org/OutOfStock',
                'seller' => new Thing('Organization', [
                    'name' => config('site_app_name'),
                    '@id' => route('product.details', $product->link) . '#organization'
                ]),
            ]),
            // 'review' => $this->generateReviewSchema($product),
            // 'aggregateRating' => $this->generateAggregateRating($product),
            // 'additionalProperty' => $this->generateProductProperties($product),
        ]);

        // WebPage Schema
        $webPageSchema = new Thing('WebPage', [
            '@id' => route('product.details', $product->link),
            'name' => $product->name,
            'url' => route('product.details', $product->link),
            'description' => $product->short_text,
            'primaryImageOfPage' => $product->has_variants ? $product->defaultVariant->first_image : $product->main_image_path,
            'isPartOf' => new Thing('WebSite', [
                '@id' => url('/')
            ]),
            'datePublished' => $this->ISoDateTimeFormate($product->created_at),
            'dateModified' => $this->ISoDateTimeFormate($product->updated_at),
            'breadcrumb' => new Thing('BreadcrumbList', [
                '@id' => route('product.details', $product->link)
            ]),
            'potentialAction' => [
                new Thing('ReadAction', [
                    'target' => [route('product.details', $product->link)]
                ])
            ]
        ]);

        // Organization Schema
        $organizationSchema = new Thing('Organization', [
            '@id' => url('/'),
            'name' => config('site_app_name'),
            'url' => url('/'),
            'logo' => new Thing('ImageObject', [
                'url' => config('site_logo')
            ]),

        ]);

        // Combine all schemas
        $schema = new Schema(
            $productSchema,
            $webPageSchema,
            $organizationSchema,
        );

        // Meta Tags
        $metatags = new MetaTags();
        $metatags
            ->title($product->meta_title ?? $product->name ?? '')
            ->description($product->meta_description ?? $product->short_text ?? '')
            ->meta('author', config('site_app_name'))
            ->meta('time', date('D M j G:i:s T Y', strtotime($product->created_at)))
            ->image($product->has_variants ? $product->defaultVariant->first_image : $product->main_image_path)
            ->mobile(route('product.details', $product->link))
            ->canonical(route('product.details', $product->link))
            ->shortlink(route('product.details', $product->link))
            ->meta('robots', 'index');

        return [$schema, $metatags];
    }

    public function inspectionRequestPageSeo()
    {

        $seo = SeoAssistant::first();
        $metatags = new MetaTags();


        $metatags
            ->title($seo->inspection_request_meta_title ?? config('site_app_name'))
            ->description($seo->inspection_request_meta_desc ?? strip_tags(config('site_about_app')))
            ->meta('author', config('site_app_name'))
            ->image(config('site_logo'))
            ->mobile(route('website.inspection.request'))
            ->canonical(route('website.inspection.request'))
            ->shortlink(route('website.inspection.request'))
            ->meta('robots', ($seo->inspection_request_meta_robots) ? 'index' : 'noindex');

        $schema = new Schema(
            new Thing('Article', [
                'url' => route('website.inspection.request'),
                'image' => config('site_logo'),
                'headline' => $seo->inspection_request_meta_title ?? config('site_app_name'),
                'author' => new Thing('author', [
                    'name' => config('site_app_name'),
                    'url' => route('website.inspection.request'),
                ]),

                'datePublished' => now()->toIso8601String(),
                'dateModified' => now()->toIso8601String(),
            ])
        );
        return [$schema, $metatags];
    }

    public function commercialRequestPageSeo()
    {
        $seo = SeoAssistant::first();
        $metatags = new MetaTags();

        $metatags
            ->title($seo->commercial_request_meta_title ?? config('site_app_name'))
            ->description($seo->commercial_request_meta_desc ?? strip_tags(config('site_about_app')))
            ->meta('author', config('site_app_name'))
            ->image(config('site_logo'))
            ->mobile(route('website.commercial.request'))
            ->canonical(route('website.commercial.request'))
            ->shortlink(route('website.commercial.request'))
            ->meta('robots', ($seo->commercial_request_meta_robots) ? 'index' : 'noindex');

        $schema = new Schema(
            new Thing('Article', [
                'url' => route('website.commercial.request'),
                'image' => config('site_logo'),
                'headline' => $seo->commercial_request_meta_title ?? config('site_app_name'),
                'author' => new Thing('author', [
                    'name' => config('site_app_name'),
                    'url' => route('website.commercial.request'),
                ]),

                'datePublished' => now()->toIso8601String(),
                'dateModified' => now()->toIso8601String(),
            ])
        );
        return [$schema, $metatags];
    }

    public function contactUsPageSeo()
    {

        $seo = SeoAssistant::first();
        $metatags = new MetaTags();

        $metatags
            ->title(($seo->contact_meta_title) ?? config('site_app_name'))
            ->description(($seo->contact_meta_desc) ?? strip_tags(config('site_site_description')))
            ->meta('author', config('site_app_name'))
            ->image(config('site_logo'))
            ->mobile(route('website.contact'))
            ->canonical(route('website.contact'))
            ->shortlink(route('website.contact'))
            ->meta('robots', ($seo->contact_meta_robots) ? 'index' : 'noindex');

        $schema = new Schema(
            new Thing('Article', [
                'url' => route('website.contact'),
                'image' => config('site_logo'),
                'headline' => ($seo->contact_meta_title) ?? config('site_app_name'),
                'author' => new Thing('author', [
                    'name' => config('site_app_name'),
                    'url' => route('website.contact'),
                ]),
            ])
        );
        return [$schema, $metatags];
    }


    public function getPageSeo($page)
    {
        $seo = SeoAssistant::first();
        $metatags = new MetaTags();

        $metatags
            ->title($page->meta_title ?? config('site_app_name'))
            ->description($page->meta_description ?? strip_tags(config('site_site_description')))
            ->meta('author', config('site_app_name'))
            ->meta('time', date('D M j G:i:s T Y', strtotime($page->created_at)))
            ->image(url("uploads/settings/source/" . config('site_logo')))
            ->mobile(route('website.page.details', $page->link))
            ->canonical(route('website.page.details', $page->link))
            ->shortlink(route('website.page.details', $page->link))
            ->meta('robots', ($page->index) ? 'index' : 'noindex');

        $schema = new Schema(
            new Thing('Article', [
                'url' => route('website.page.details', $page->link),
                'image' => config('site_logo'),
                'headline' => ($seo->about_meta_title) ? $seo->about_meta_title : config('site_app_name'),
                'author' => new Thing('author', [
                    'name' => config('site_app_name'),
                    'url' => route('website.page.details', $page->link),
                ]),
            ])
        );

        return [$schema, $metatags];
    }


 
    public function blogsPageSeo()
    {
        $seo = SeoAssistant::first();
     
        $metatags = new MetaTags();
       

        $metatags
            ->title( $seo->meta_title ?? config('site_app_name'))
            ->description( $seo->meta_desc ?? strip_tags(config('site_about_app')) ?? '')
            ->meta('author', config('site_app_name'))
            ->image(config('site_logo'))
            ->mobile(route('website.blogs'))
            ->canonical(route('website.blogs'))
            ->shortlink(route('website.blogs'))
            ->meta('robots', ($seo->blogs_meta_robots) ? 'index' : 'noindex');

        $schema = new Schema(
            new Thing('Article', [
                'url' => route('website.blogs'),
                'image' =>  config('site_logo'),
                'headline' => ($seo->blog_meta_title) ?? config('site_app_name'),
                'author' => new Thing('author', [
                    'name' => config('site_app_name'),
                    'url' => route('website.blogs'),
                ]),

            ])
        );
        return [$schema, $metatags];
    }

  

    public function blogPageSeo($blog)
    {
     
       
        $seo = SeoAssistant::first();
        $metatags = new MetaTags();

        $metatags
            ->title($blog->meta_title)
            ->description($blog->meta_description ?? '')
            ->meta('author', config('site_app_name'))
            ->meta('time', date('D M j G:i:s T Y', strtotime($blog->date)))
            ->image($blog->image_path ?? config('site_logo'))
            ->mobile(route('website.blog.details',$blog->slug))
            ->canonical(route('website.blog.details',$blog->slug))
            ->shortlink(route('website.blog.details',$blog->slug))
            ->meta('robots', ($blog->index) ? 'index' : 'noindex');

        $schema = new Schema(
            new Thing('Article', [
                'url' => route('website.blog.details', $blog->slug),
                'image' => $blog->image_path ?? config('site_logo'),
                'headline' => ($seo->about_meta_title) ? $seo->about_meta_title : config('site_app_name'),
                'author' => new Thing('author', [
                    'name' => config('site_app_name'),
                    'url' => route('website.home'),
                ]),
                'datePublished' => $this->ISoDateTimeFormate($blog->created_at),
                'dateModified' => $this->ISoDateTimeFormate($blog->updated_at),
            ])
        );

        return [$schema, $metatags];
    }

    public function branchesPageSeo()
    {
        $lang = LaravelLocalization::getCurrentLocale();
        $seo = SeoAssistant::first();
        $metatags = new MetaTags();
        $about = About::first();

        $metatags
            ->title(($seo->branches_meta_title || $seo->branches_meta_title_ar) ? (($lang == 'en') ? $seo->branches_meta_title : $seo->branches_meta_title_ar) : config('site_app_name'))
            ->meta('title', ($seo->branches_meta_title || $seo->branches_meta_title_ar) ? (($lang == 'en') ? $seo->branches_meta_title : $seo->branches_meta_title_ar) : config('site_app_name'))
            ->description(($seo->branches_meta_desc || $seo->branches_meta_desc_ar) ? (($lang == 'en') ? $seo->branches_meta_desc : $seo->branches_meta_desc_ar) : strip_tags(config('site_about_app')))
            ->meta('author', config('site_app_name'))
            ->image(url("uploads/settings/source/" . config('site_logo')))
            ->mobile(LaravelLocalization::localizeUrl('/branches'))
            ->canonical(LaravelLocalization::localizeUrl('/branches'))
            ->shortlink(LaravelLocalization::localizeUrl('/branches'))
            ->meta('robots', ($seo->branches_index) ? 'index' : 'noindex');

        $schema = new Schema(
            new Thing('Article', [
                'url' => LaravelLocalization::localizeUrl("/about-us"),
                'image' => url("uploads/settings/source/" . config('site_logo')),
                'headline' => (($seo->about_meta_title || $seo->about_meta_title_ar) ? (($lang == 'en') ? $seo->about_meta_title : $seo->about_meta_title_ar) : config('site_app_name')),
                'author' => new Thing('author', [
                    'name' => config('site_app_name'),
                    'url' => LaravelLocalization::localizeUrl("/about-us"),
                ]),

                'datePublished' => $this->ISoDateTimeFormate($about->created_at),
                'dateModified' => $this->ISoDateTimeFormate($about->updated_at),
            ])
        );
        return [$schema, $metatags];
    }

}
