<?php

namespace App\Services;

use App\Models\Cart;
use App\Models\Governorate;

class ShippingService
{


    public function fees($cart , $governorate = null)
    {
      return   $this->calculateFees($cart,$governorate);
    }

    protected function calculateFees(Cart $cart, $governorate = null)
    {

        $free_shipping = $cart->total_price >= config('site_free_amount', 0);

        if ($free_shipping) {

            return 0.00;

        } elseif (config('site_standard_shipping_fees', 0) > 0 && $governorate == null) {

            return  config('site_standard_shipping_fees', 0);

        } elseif ($governorate) {

            Governorate::findOrFail($governorate);

            $governorateFees = Governorate::find($governorate)->shipping_fees;

            return round( $governorateFees);
        }
    }

   
}
