<?php

namespace App\Services;

use GuzzleHttp\Psr7\Request;
use Illuminate\Support\Facades\Http;
use Illuminate\Support\Facades\Log;

class PaymobPaymentService
{
    protected $secretKey;
    protected $publicKey;
    protected $integrationId;


    public function __construct()
    {
        $this->integrationId = config('app.integration_id'); // Store integration ID in config

        $this->secretKey = config('app.secret_key'); // Store Secret key in config

        $this->publicKey = config('app.public_key'); // Store Public key in config
    }

    ////////////////////////////////

    public function intention($amountCents, $orderItems, $billingData, $merchantOrderId)
    {

        $client = new \GuzzleHttp\Client();

        $headers = [
            'Authorization' => 'Token ' . $this->secretKey,
            'Content-Type' => 'application/json'
        ];

        $body = [
            "amount" =>$amountCents,
            "currency" => "EGP",
            "payment_methods" => [(int)$this->integrationId],
            "items" => $orderItems,
            "billing_data" => $billingData,
            "special_reference" =>  $merchantOrderId . '-' . time(),

        ];

        // Convert the body array to a JSON string

        $jsonBody = json_encode($body);

        try {

            $request = new Request('POST', 'https://accept.paymob.com/v1/intention/', $headers, $jsonBody);

            $response = $client->sendAsync($request)->wait();

            $jsonResponse = json_decode($response->getBody(), true);

            $clientSecret = $jsonResponse['client_secret'];

            header('location: https://accept.paymob.com/unifiedcheckout/?publicKey=' . $this->publicKey . '&clientSecret=' . $clientSecret);

            exit;
            
        } catch (\GuzzleHttp\Exception\RequestException $e) {
            $responseBody = $e->getResponse() ? $e->getResponse()->getBody()->getContents() : 'No response';
            Log::error('Paymob API Error: ' . $e->getMessage(), ['response' => $responseBody]);
            return response()->json(['error' => 'Payment failed. Try again.'], 500);
        }
    }
}
