<?php

namespace App\Services;

use App\Models\Blog;
use App\Models\Category;
use App\Models\Product;
use Spatie\Sitemap\Sitemap;
use Spatie\Sitemap\Tags\Url;

class BuildSitemapService
{

    public function generateSitemap()
    {
        Sitemap::create()
            ->add($this->build_index(Category::active()->get(), 'sitemap_categories.xml'))
            ->add($this->build_index(Product::active()->get(), 'sitemap_products.xml'))
            ->add($this->build_index(Blog::active()->get(), 'sitemap_blogs.xml'))
            ->add(Url::create('/')->setPriority(1)->setChangeFrequency(Url::CHANGE_FREQUENCY_ALWAYS))
            ->add(Url::create('/about-us')->setPriority(0.5)->setChangeFrequency(Url::CHANGE_FREQUENCY_MONTHLY))
            ->add(Url::create('/contact-us')->setPriority(0.5)->setChangeFrequency(Url::CHANGE_FREQUENCY_MONTHLY))
            ->add(Url::create('/commercial-request')->setPriority(0.5)->setChangeFrequency(Url::CHANGE_FREQUENCY_MONTHLY))
            ->add(Url::create('/inspection-request')->setPriority(0.5)->setChangeFrequency(Url::CHANGE_FREQUENCY_MONTHLY))
            ->add(Url::create('/branches')->setPriority(0.5)->setChangeFrequency(Url::CHANGE_FREQUENCY_MONTHLY))
            ->writeToFile(public_path('sitemap.xml'));
    }

    protected function build_index($model , $path): string
    {
        Sitemap::create()
        ->add($model)
        ->writeToFile(public_path($path));

        return $path;
    }
}
