<?php

namespace App\Providers;

use Illuminate\Cache\RateLimiting\Limit;
use Illuminate\Foundation\Support\Providers\RouteServiceProvider as ServiceProvider;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\RateLimiter;
use Illuminate\Support\Facades\Route;
use Mcamara\LaravelLocalization\Facades\LaravelLocalization;

class RouteServiceProvider extends ServiceProvider
{
    /**
     * The path to your application's "home" route.
     *
     * Typically, users are redirected here after authentication.
     *
     * @var string
     */
    public const HOME = '/';
    protected $namespace = 'App\Http\Controllers';
    // protected $adminnamespace = 'App\Http\Controllers\Admin';
    protected $usernamespace = 'App\Http\Controllers\website\UserBoard';
    protected $adminFiles = [
         'menus.php',

        // 'about.php',

        // 'aboutStrucs.php',
        // 'sliders.php',
        // 'brands.php',
        //  'categories.php',
        // 'discounts.php',
        'products.php',

        // 'shippingFees.php',
        // 'seo-assistant.php',
        // 'coupon.php',
         'admin.php',
        //  'attributes.php',
        // 'setting.php' ,
        // 'configrations.php',
        // 'deliveries.php',
        // 'pages.php' ,
        // 'permissions.php',
        // 'roles.php',
        // 'areas.php' ,
        // 'Governorates.php',
        // 'configrations.php' ,
        // 'countries.php' ,
        // 'orders.php',
        // 'contactUs.php',
        // 'siteAddressess.php',
        // 'paymentMethods.php',
        // 'users.php',

    ];


    protected $websitenamespace = 'App\Http\Controllers\Website';
    protected $websiteFiles = [
        'website.php' ,
        'cart.php',
      
    
    ];
    protected $userFiles = [
        'user.php',
    ];
    protected $apinamespace = 'App\Http\Controllers\Api';

    /**
     * Define your route model bindings, pattern filters, and other route configuration.
     */
    public function boot(): void
    {
        RateLimiter::for('api', function (Request $request) {
            return Limit::perMinute(60)->by($request->user()?->id ?: $request->ip());
        });

        $this->routes(function () {
            Route::middleware('api')
                ->prefix('api')
                ->group(base_path('routes/api.php'));

            Route::middleware('web')
                ->namespace($this->namespace)
                ->group(base_path('routes/web.php'));


            // Admin Routes
            Route::middleware(['web', 'localeSessionRedirect', 'localizationRedirect', 'localeViewPath', 'admin'])
                ->prefix(LaravelLocalization::setLocale().'/admin')
                ->group(function () {
                    foreach ($this->adminFiles as $routeFile) {
                        require base_path('routes/admin/' . $routeFile);
                    }
            });
              // Auth User Routes
            Route::middleware(['web', 'localeSessionRedirect', 'localizationRedirect', 'localeViewPath'])
                ->namespace($this->usernamespace)
                ->prefix(LaravelLocalization::setLocale())
                ->group(function () {
                    foreach ($this->userFiles as $routeFile) {
                        require base_path('routes/website/'. $routeFile);
                    }
            });

            // website Routes
            Route::middleware(['web', 'localeSessionRedirect', 'localizationRedirect', 'localeViewPath'])
                // ->namespace($this->websitenamespace)
                ->prefix(LaravelLocalization::setLocale())
                ->group(function () {
                    foreach ($this->websiteFiles as $routeFile) {
                        require base_path('routes/website/' . $routeFile);
                    }
            });
           

        });
    }
}
