<?php

namespace App\Models;

use App\Helpers\Helper;
use Illuminate\Database\Eloquent\Model;

class UserAddress extends Model
{

    protected $table = 'user_addresses';

    protected $fillable = [
        'user_id',
        'country_id',
        'governorate_id',
        'city',
        'address',
        'phone',
        'is_primary',
        'postal_code'

    ];

    public function country()
    {
        return $this->belongsTo(Country::class, 'country_id');
    }

    public function governorate()
    {
        return $this->belongsTo(Governorate::class, 'governorate_id');
    }


    public function user()
    {
        return $this->belongsTo(User::class, 'user_id');
    }

    public function orders()
    {
        return $this->hasMany(Order::class ,'order_id');
    }


    public function getFullAddressAttribute()
    {
        return $this->address . ' - ' .  $this->city . ' - ' . $this->governorate->{'name_' . Helper::getLang()} . ' - ' . $this->country->{'name_' . Helper::getLang()};
    }
}
