<?php

namespace App\Models;

use App\Helpers\Helper;
use App\Traits\Carts\CartTrait;
use Illuminate\Contracts\Auth\MustVerifyEmail;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Notifications\Notifiable;
use Spatie\Permission\Traits\HasRoles;
use Tymon\JWTAuth\Contracts\JWTSubject;
use Illuminate\Contracts\Auth\CanResetPassword;
class User extends Authenticatable implements JWTSubject
{
    use HasRoles;
    use Notifiable;
    use  CartTrait;
    protected $table='users';

    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = [
        'f_name',
        'l_name',
        'phone',
        'email',
        'image',
        'them',
        'email_verified_at',
        'password',
        'is_admin',
        'admin_seen',

    ];

    /**
     * The attributes that should be hidden for arrays.
     *
     * @var array
     */
    protected $hidden = [
        'password', 'remember_token',
    ];

    /**
     * The attributes that should be cast to native types.
     *
     * @var array
     */
    protected $casts = [
        'email_verified_at' => 'datetime',
    ];




    public function addresses(){
        return $this->hasMany(UserAddress::class) ;
    }

    public function getPrimaryAddressAttribute(){
        return $this->addresses()->where('is_primary', 1)->first() ?? $this->addresses()->first() ;
    }

    public function getNameAttribute(){
        return $this->f_name.' '.$this->l_name;
    }






    


    public function getJWTIdentifier()
    {
        return $this->getKey();
    }
    public function getJWTCustomClaims()
    {
        return [];
    }

    public function couponUseds(){
        return $this->hasMany(CouponUsed::class) ;
    }




    public function isAdmin(){
        return $this->is_admin;
    }

    

    public function name(){
        return $this->f_name.' '.$this->l_name;
    }

    public function getImage200Attribute(){

        return $this->image  ? Helper::uploadedImagesPath('users',$this->image)  : Helper::noImage() ;
    }

    public function getImageSourceAttribute(){

        return $this->image  ? Helper::uploadedImagesPath('users',$this->image)  : Helper::noImage() ;
    }

    public function getPrimaryAddressFeesAttribute()
    {

        return  $this->primary_address ?$this->primary_address->Governorate->shipping_fees +$this->primary_address->area->shipping_fees : 0;

    }
    public function getPrimaryAddressFeesTotalPriceAttribute()
    {


            $cart = $this->getCart();

        return  $this->primary_address_fees + $cart->total_price;

    }



}
