<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class SimpleRequestOrderOrderItems extends Model
{
    use HasFactory;
    protected $table = 'simple_request_order_order_items';
    protected $fillable = [
        'order_id',
        'product_id',
        'product_variant_id',
    ];

    public function order()
    {
        return $this->belongsTo(SimpleRequestOrder::class, 'order_id');
    }
    public function product()
    {
        return $this->belongsTo(Product::class, 'product_id');
    }

    public function productVariant(){
        return $this->belongsTo(ProductVariant::class, 'product_variant_id');
    }

}
