<?php

namespace App\Models;

use App\Helpers\Helper;
use Illuminate\Database\Eloquent\Model;
use DB;

use Illuminate\Database\Eloquent\Factories\HasFactory;

class ProductVariant extends Model
{
    use HasFactory;
	protected $table='product_variants';

    protected $fillable = [
        'product_id',
        'value_id',
        'additional_price',
        'stock',

    ];


    public function images()
    {
        return $this->morphMany(Image::class, 'imageable');;
    }

    public function getFirstImageAttribute()
    {
        return $this->images->first() ? asset('storage/products/variants/'.$this->images->first()->image) : Helper::noImage();
    }
    public function getSecondImageAttribute()
    {
        return $this->images->skip(1)->first() ?asset('storage/products/variants/'.$this->images->skip(1)->first()->image) : $this->first_image;
    }


    public function product()
    {
        return $this->belongsTo(Product::class, 'product_id');
    }


    public function values()
    {
        return $this->hasMany(VariantValue::class, 'variant_id');
    }



    public function getColorAttribute()
    {
        return $this->values->filter(function ($value) {
            return $value->value->attribute->name === 'Color';
        })->first()->value->code ?? null;
    }
}
