<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Payment extends Model
{
    use HasFactory;
    protected $table = 'payments';
    protected $fillable = [
        'order_id',
        'simple_request_order_id',
        'user_id',
        'payment_method_id',
        'amount',
        'status',
        'processed_at',
       
    ];


    protected static function boot()
    {
        parent::boot();

        static::creating(function ($payment) {
            $payment->processed_at = now();
        });
    }
    public function order()
    {
        return $this->belongsTo(Order::class);
    }
    public function user()
    {
        return $this->belongsTo(User::class);
    }
    public function paymentMethod()
    {
        return $this->belongsTo(PaymentMethod::class);
    }
    
}
