<?php

namespace App\Models;

use App\Helpers\Helper;
use Illuminate\Database\Eloquent\Model;
use Mcamara\LaravelLocalization\Facades\LaravelLocalization;

class Page extends Model
{
    protected $table = 'pages';
    private $lang;
    protected $fillable = [
        'title_ar',
        'title_en',
        'text_ar',
        'text_en',
        'link_en',
        'link_ar',
        'meta_title_ar',
        'meta_title_en',
        'meta_description_ar',
        'meta_description_en',
        'status',
        'index',

    ];

    public function __construct(array $attributes = [])
    {
        parent::__construct($attributes);

        // Set the current locale dynamically
        $this->lang = Helper::getLang();
    }
    public function getTitleAttribute()
    {

        return $this->{'title_' . $this->lang};
    }


    public function getTextAttribute()
    {
        return $this->{'text_' . $this->lang};
    }
    public function getLinkAttribute()
    {
        return $this->{'link_' . $this->lang};
    }

    public function getActiveAttribute()
    {
        $this->status ? __('home.yes') : __('home.no');
    }

    public function scopeActive($query)
    {
        $query->whereStatus(1);
    }

    public function scopeUnactive($query)
    {
        $query->whereStatus(0);
    }

    public function getMetaTitleAttribute()
    {
        return $this->{'meta_title_' . $this->lang};
    }

    public function getMetaDescAttribute()
    {
        return $this->{'meta_description_' . $this->lang};
    }
}
