<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class OrderShipment extends Model
{
    use HasFactory;

    protected $table = 'order_shipments';

    protected $fillable = [
        'order_id',
        'simple_request_order_id',
        'tracking_number',
        'carrier',
        'order_shipment_status_id',
        'shipped_at',
        'delivered_at',
    ];

    public function order()
    {
        return $this->belongsTo(Order::class);
    }

    protected function casts(): array
    {
        return [
            'shipped_at'   => 'datetime',
            'delivered_at' => 'datetime',
        ];
    }

    public function simpleRequestOrder()
    {
        return $this->belongsTo(SimpleRequestOrder::class, 'simple_request_order_id');
    }

    // Relationship to shipment status
    public function shipmentStatus()
    {
        return $this->belongsTo(OrderShipmentStatus::class, 'order_shipment_status_id');
    }
}
