<?php

namespace App\Models;
use App\Models\OrderProductOption;

use Illuminate\Database\Eloquent\Model;

class OrderItem extends Model
{
    //
    protected $table = 'order_items';

    protected $fillable = [
        'order_id',
        'product_id',
        'product_variant_id',
        'price',
        'quantity',
    ];

    public function product(){
        return $this->belongsTo(Product::class, 'product_id');
    }
    public function productVariant(){
        return $this->belongsTo(ProductVariant::class, 'product_variant_id');
    }
    public function order(){
        return $this->belongsTo(Order::class);
    }

    public function variant()
    {
        return $this->belongsTo(ProductVariant::class,'product_variant_id');
    }


    public function getTotalPriceAttribute()
    {
        return $this->price * $this->quantity;
    }
}
