<?php

namespace App\Models;

use App\Helpers\Helper;
use Illuminate\Database\Eloquent\Model;
use DB;


class Governorate extends Model
{
    //
    protected $table = 'governorates';

    protected $fillable = [
        'name_en',
        'name_ar',
        'country_id',
        'shipping_fees',
        'simple_request_shipping_fees',
        'status'
    ];

    private $lang;

    public function __construct(array $attributes = [])
    {
        parent::__construct($attributes);

        // Set the current locale dynamically
        $this->lang = Helper::getLang();
    }
    public function delete()
    {
        if ($this->addresses) {
            foreach ($this->addresses as  $value) {
                if ($value->orders) {
                    throw new \Exception('Cannot delete an Governorate that has related addresses that has related orders.');
                }
            }
        }

        return parent::delete();
    }


    public function country()
    {
        return $this->belongsTo(Country::class);
    }

    public function addresses()
    {
        return $this->hasMany('App\Models\Address', 'Governorate_id');
    }

    public function areas()
    {
        return $this->hasMany('App\Models\Area');
    }


    function scopeCheckBeforDelete($query)
    {
        return $query->whereHas('addresses')
            ->orWhereHas('areas');
    }

    public function getNameAttribute()
    {
        return $this->{'name_' . $this->lang};
    }
    public function branches()
    {
        return $this->hasMany(Branch::class);
    }
}
