<?php

namespace App\Models;

use App\Helpers\Helper;
use Illuminate\Database\Eloquent\Model;
use DB;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class Country extends Model
{
   use  HasFactory;
    //
	protected $table='countries';

    protected $fillable = ['name_en','name_ar','status'];

    private $lang ;
    public function __construct(array $attributes = [])
    {
        parent::__construct($attributes);

        // Set the current locale dynamically
        $this->lang = Helper::getLang();

    }

    public function delete()
    {
        if ( $this->addresses()->exists()) {
            $errors[] = 'Cannot delete an country that has related addresses that has related orders.';
        }

        return parent::delete();
    }
    public function addresses(){
        return $this->hasMany('App\Models\Address','country_id');
    }

    public function Governorates(){
        return $this->hasMany('App\Models\Governorate');
    }

    public function getNameAttribute(){
        return $this->{'name_'.$this->lang};
    }

    

    function scopeCheckBeforDelete($query){
        return $query->whereHas('addresses');
    }
}
