<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class CommercialRequest extends Model
{
    use HasFactory;

    protected $fillable = [
  
        'name',
        'email',
        'phone',
        'country_id',
        'governorate_id',
        'city',
        'address',
        'type_of_activity',
        'category',
        'price_category',
        'note',
    ];

    public function country()
    {
        return $this->belongsTo(Country::class, 'country_id');
    }

    public function governorate()
    {
        return $this->belongsTo(Governorate::class, 'governorate_id');
    }

    public function getFullAddressAttribute()
    {
        return $this->address . ' - ' . $this->city . ' - ' . ($this->governorate ? $this->governorate->name : '') . '- ' . ($this->country ? $this->country->name : '');
    }
}
