<?php

namespace App\Models;

use App\Helpers\Helper;
use Illuminate\Database\Eloquent\Model;
use DB;


class City extends Model
{
    //
	protected $table='cities';

    protected $fillable = ['name_en','name_ar','governorate_id','shipping_fees','status'];

    public function delete()
    {
        $errors = [] ;
        if ( $this->addresses &&$this->addresses()->exists() ) {

            $errors[] = 'Cannot delete an area that has related addresses.';

        }
        if(count( $errors)){
            return $errors;
           }

           return parent::delete();
    }

    private $lang ;
    public function __construct(array $attributes = [])
    {
        parent::__construct($attributes);

        // Set the current locale dynamically
        $this->lang = Helper::getLang();

    }

    public function governorate(){
        return $this->belongsTo(Governorate::class,'governorate_id');
    }

    public function addresses(){
        return $this->hasMany('App\Models\Address','area_id');
    }


    function scopeCheckBeforDelete($query){
        return $query->whereHas('addresses');
    }

    public function getNameAttribute(){
        return $this->{'name_'.$this->lang};
    }

}
