<?php

namespace App\Models;

use App\Helpers\Helper;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Branch extends Model
{
    use HasFactory;

    protected $fillable = [
        'governorate_id',
        'name_en',
        'name_ar',
        'address_en',
        'address_ar',
        'phone',
        'phone2',
        'telephone',
        'map_url',
        'status',
    ];

    public function governorate()
    {
        return $this->belongsTo(Governorate::class);
    }

    public function getNameAttribute()
    {
        return $this->{'name_' . Helper::getLang()};
    }

    public function getAddressAttribute()
    {
        return $this->{'address_' . Helper::getLang()};
    }
}
