<?php

namespace App\Models;

use App\Helpers\Helper;
use Carbon\Carbon;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Spatie\Sitemap\Contracts\Sitemapable;
use Spatie\Sitemap\Tags\Url;

class Blog extends Model implements Sitemapable
{
    use HasFactory;

    protected $fillable = [
        'name_en',
        'name_ar',
        'author',
        'image',
        'date',
        'short_content_en',
        'short_content_ar',
        'content_en',
        'content_ar',
        'slug_en',
        'slug_ar',
        'meta_title_en',
        'meta_title_ar',
        'meta_description_en',
        'meta_description_ar',
        'status',
        'show_in_home',
        'meta_robots',
      
    ];

    public function getNameAttribute()
    {
        return $this->{'name_'.Helper::getLang()};
    }

    public function getContentAttribute()
    {
        return $this->{'content_' . Helper::getLang()};
    }

    public function getImagePathAttribute()
    {
        return $this->image ? Helper::ImagePath('blogs' , $this->image) : Helper::noImage(); 
    }

    public function getSlugAttribute()
    {
        return $this->{'slug_'.Helper::getLang()};
    }

    public function scopeActive($query)
    {
        return $query->where('status', true);
    }

    public function getRouteKeyName(): string
    {
        if(!request()->is('*admin*')){

            return 'slug_' . Helper::getLang();
        }

        return 'id';
    }

    public function toSitemapTag(): Url | string | array
    {
          // Return with fine-grained control:
          return Url::create(route('website.blog.details', $this->slug))
          ->setLastModificationDate(Carbon::create($this->updated_at))
          ->setChangeFrequency(Url::CHANGE_FREQUENCY_YEARLY)
          ->setPriority(0.5);
    }

    public function getMetaTitleAttribute()
    {
        return $this->{'meta_title_' . Helper::getLang()};
    }

    public function getMetaDescriptionAttribute()
    {
        return $this->{'meta_description_' . Helper::getLang()};
    }

}
