<?php

namespace App\Models;

use App\Helpers\Helper;
use App\Helpers\SaveImageTo3Path;
use App\Models\ProductAttribute;
use App\Models\AttributeValue;
use Illuminate\Database\Eloquent\Model;
use DB;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Mcamara\LaravelLocalization\Facades\LaravelLocalization;

class Attribute extends Model
{

    use HasFactory;

	protected $table = 'attributes';

    protected $fillable = [
        'name_ar',
        'name_en',
        'status',

    ];

    public function isColor(): bool
    {
       
        return strtolower($this->name_en) === 'Color' || strtolower($this->name_en) == 'color' || strtolower($this->name_ar) == 'لون';
    }


    public function values(){
        return $this->hasMany(AttributeValue::class);
    }


    public function getNameAttribute(){
        return $this->{'name_'.Helper::getLang()};
    }

    public function getActiveAttribute(){
        $this->status ? __('home.yes') : __( 'home.no') ;
     }

     public function scopeActive($query){
         $query->whereStatus(1);
      }

      public function scopeUnactive($query){
         $query->whereStatus(0);
      }
}



