<?php

namespace App\Models;

use App\Helpers\Helper;
use App\Helpers\SaveImageTo3Path;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Mcamara\LaravelLocalization\Facades\LaravelLocalization;

class About extends Model
{
    use HasFactory;
    protected $table = 'about';
    private $lang;


    protected $fillable = [
        'title_ar',    // Arabic title
        'title_en',    // English title
        'title2_en',
        'title2_ar',
        'banner_title_en',
        'banner_title_ar',
        'short_text_en',
        'short_text_ar',
        'text_title2_en',
        'text_title2_ar',
        'text_ar',     // Arabic text content
        'text_en',     // English text content
        'video_link',  // Link to video (optional)
        'image',       // Image filename or path (optional)
        'alt_image',
        'banner',        // Icon filename or path (optional)
        'alt_banner',
        'franchise_title_en',
        'franchise_title_ar',
        'franchise_text_en',
        'franchise_text_ar',
        'franchise_image',
        'alt_franchise_image'
    ];

    public function __construct(array $attributes = [])
    {
        parent::__construct($attributes);

        // Set the current locale dynamically
        $this->lang = Helper::getLang();
    }
    public function getTitleAttribute()
    {
        return  $this->{'title_' . $this->lang};
    }

    public function getTitle2Attribute()
    {
        return  $this->{'title2_' . $this->lang};
    }

    public function getBannerTitleAttribute()
    {
        return  $this->{'banner_title_' . $this->lang};
    }
    public function getFranchiseTitleAttribute()
    {
        return  $this->{'franchise_title_' . $this->lang};
    }

    public function getFranchiseTextAttribute()
    {
        return  $this->{'franchise_text_' . $this->lang};
    }
    public function getShortTextAttribute()
    {
        return  $this->{'short_text_' . $this->lang};
    }
    public function getTextTitle2Attribute()
    {
        return  $this->{'text_title2_' . $this->lang};
    }
    public function getTextAttribute()
    {
        return  $this->{'text_' . $this->lang};
    }

    public function getImageSourceAttribute($image)
    {
        return Helper::imageIsExists($this->image, 'aboutStrucs') ? Helper::uploadedImagesPath('aboutStrucs', $this->image) : url(Helper::noImage());
    }

    public function getBannerSourceAttribute($banner)
    {
        return Helper::imageIsExists($this->banner, 'aboutStrucs') ? Helper::uploadedImagesPath('aboutStrucs', $this->banner) : url(Helper::noImage());
    }


    public function getImage200Attribute($image)
    {
        return Helper::imageIsExists($this->image, 'aboutStrucs') ? Helper::uploadedImages200Path('aboutStrucs', $this->image) : url(Helper::noImage());
    }

    public function getBanner200Attribute($banner)
    {
        return Helper::imageIsExists($this->banner, 'aboutStrucs') ? Helper::uploadedImages200Path('aboutStrucs', $this->banner) : url(Helper::noImage());
    }

  
}
