<?php

namespace App\Http\Requests\Website;

use Illuminate\Foundation\Http\FormRequest;

class PlaceOrderRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }


    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        return [
            'f_name' => ['required', 'string'],
            'l_name' => ['required', 'string'],
            'phone' => ['required', 'string'],
            // 'email' => ['nullable', 'string', 'email:rfc,dns', 'max:150',],
            'email' => ['nullable', 'string', 'email', 'max:150',],
            'country_id' => ['required', 'exists:countries,id'],
            'governorate_id' => ['required', 'exists:governorates,id'],
            'city' => ['required', 'string'],
            'address' => ['required','string'],
            'note' => ['nullable'],
            // 'shipping_fees' => ['required'],
            // 'total_price' => ['required'],
            'payment_method_id' => ['required', 'exists:payment_methods,id'],
            // 'payment_fees' => ['required'],
        ];
    }
}
