<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class UpdateSiteAddressRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        return [
            'title_en' => 'nullable|string|max:255',
            'title_ar' => 'nullable|string|max:255',
            'address_ar' => 'nullable|string|max:4294967295',
            'address_en' => 'nullable|string|max:4294967295',
            'email' => 'nullable|email',
            'phone1' => 'nullable',
            'code1' => 'required_with:phone1',
            'phone2' => 'nullable',
            'code2' => 'required_with:phone2',
            'map_url' => 'nullable|string',
            'order' => 'nullable|integer',
            'status'=>'nullable|boolean'
        ];
    }
}
