<?php

namespace App\Http\Requests;

use App\Models\Setting;
use Illuminate\Foundation\Http\FormRequest;

class SettingRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        return [
            'lang' => 'nullable|in:en,ar',
            'free_amount' => 'nullable|numeric|min:0',
            'standard_shipping_fees' => 'nullable|numeric|min:0',
            'contact_email' => 'nullable|email|max:255',
            'email' => 'nullable|email|max:255',
            'telephone' => 'nullable|numeric',
            'mobile' => 'nullable|numeric',
            'fax' => 'nullable|numeric',
            'whatsapp' => 'nullable|numeric',
            'snapchat' => 'nullable|string|max:255',
            'facebook' => 'nullable|url|max:500',
            'linkedin' => 'nullable|url|max:500',
            'instgram' => 'nullable|url|max:500',
            'twitter' => 'nullable|url|max:500',
            'tiktok' => 'nullable|url|max:500',
            'map_url' => 'nullable|url|max:1000',
            'place_order_msg' => 'nullable|string|max:1000',
            'free_amount' => 'nullable|numeric|min:0',
            'standard_shipping_fees' => 'nullable|numeric|min:0',
            'gtm_script' => ['nullable'],
            'gtm_noscript' => ['nullable'],



        ];



    }
}
