<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;
use Mcamara\LaravelLocalization\Facades\LaravelLocalization;

class ReportRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return  true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        return [
            'start_date' => ['required','date'],
            'end_date' => ['required','date','after:start_date'],
            'min_amount' => ['nullable'],
            'max_amount' => ['nullable'],
            'status_id' => ['nullable','exists:order_statuses,id'],
            'brand_id' => ['nullable','exists:brands,id'],
            'category_id' => ['nullable','exists:categories,id'],
            'shipping_id' => ['nullable'],
            'payment_id' => ['nullable'],
            'product_id' => ['nullable'],
          
        ];
    }
}
