<?php

namespace App\Http\Requests\ProductsDiscounts;

use App\Models\ProductDiscount;
use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Validation\Rule;

class UpdateProductDiscountRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        return [
            'name' => ['nullable','string'],
            'variant_id' => ['nullable','exists:product_variants,id'],
            'type' => ['required', Rule::in(ProductDiscount::TYPES)],
            'value' => ['required',],
            'apply_to' => ['required', 'in:product,variant'],
            'starts_at' => ['required', 'date'],
            'expires_at' => ['required', 'date', 'after_or_equal:starts_at'],
            'is_active' => ['nullable','boolean']
        ];
    }
}
