<?php

namespace App\Http\Middleware;

use App\Models\Setting;
use Closure;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Cache;
use Mcamara\LaravelLocalization\Facades\LaravelLocalization;
use Symfony\Component\HttpFoundation\Response;

class GlobalConfigMiddleware
{
    /**
     * Handle an incoming request.
     *
     * @param  \Closure(\Illuminate\Http\Request): (\Symfony\Component\HttpFoundation\Response)  $next
     */
    public function handle(Request $request, Closure $next): Response
    {
        $lang = LaravelLocalization::getCurrentLocale();

        $configrations = Cache::remember("settings_{$lang}", 3600, function () use ($lang) {
            return Setting::where('lang', $lang)
                ->get()
                ->mapWithKeys(function ($item) {
                    return ['site_' . $item->key => $item->value];
                })->toArray();
        });

        config()->set($configrations);
  
        $settings = Cache::remember("settings", 3600, function () {
            return Setting::where('lang', 'all')
                ->get()
                ->mapWithKeys(function ($item) {
                    return ['setting_' . $item->key => $item->value];
                })->toArray();
        });

        config()->set($settings);

        return $next($request);
    }
}
