<?php

namespace App\Http\Controllers\website\UserBoard;

use App\Http\Controllers\Controller;

use App\Models\Order;
use App\Models\User;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Hash;

class UserBoardController extends Controller
{

    public function showProfile()
    {

        return view('website.userBoard.profile');
    }

    public function showOrders()
    {
        $orders = Order::where('user_id', Auth::user()->id)->get();

        return view('website.userBoard.orders', compact('orders'));
    }

    public function showOrderDetails(Order $order)
    {
        return view('website.userBoard.order-details', compact('order'));
    }

    public function updateAccountData(Request $request)
    {
        $request->validate([
            'f_name' => ['required', 'string', 'max:255'],
            'l_name' => ['required', 'string', 'max:255'],
            'email' => ['required', 'string', 'email', 'max:255', 'unique:users'],
        ]);

        $user = auth()->user();
        $validatedData = $request->all();
        $user->update($validatedData);
        return  redirect()->back()->with(['success' => __('home.account information updated successfully')]);
    }

    public function updatePassword(Request $request)
{
    // Validate the form inputs
    $request->validate([
        'current_password' => 'required|string',
        'password' => 'required|string|min:8|confirmed',
    ]);

    // Get the authenticated user
    $user = Auth::user();

    // Check if the current password matches
    if (!Hash::check($request->current_password, $user->password)) {
        return back()->withErrors(['current_password' => 'The current password is incorrect.']);
    }

    // Update the password
    $user->password = Hash::make($request->password);
    $user->save();

    // Redirect with success message
    return redirect()->back()->with('success', 'Password updated successfully.');
}
}
