<?php

namespace App\Http\Controllers\website;

use App\Http\Controllers\Controller;
use App\Models\Product;
use Illuminate\Http\Request;

class SearchController extends Controller
{
    public function search(Request $request)
    {
        $query = $request->input('query');

        $results =  Product::where('name_en', 'like', "%{$query}%")
            ->orWhere('name_ar', 'like', "%{$query}%")
            ->where('status', 1)
            ->take(10)
            ->get();

            if ($request->ajax()) {
                return response()->json($results);
            } else {
                return view('website.search', ['products' => $results]);
            }
      
    }
}
