<?php

namespace App\Http\Controllers\website;

use App\Http\Controllers\Controller;
use App\Models\About;
use App\Models\AboutStruc;
use App\Models\Admin\SiteAddress;
use App\Models\Category;
use App\Models\OrderItem;
use App\Models\Page;
use App\Models\Partner;
use App\Models\Product;
use App\Models\Slider;
use App\Traits\SeoTrait;
use Illuminate\Http\Request;

class HomeController extends Controller
{
  
    use SeoTrait;
    /**
     * Handle the incoming request.
     */
    public function __invoke(Request $request)
    {
      
        $data['sliders'] = Slider::active()->whereType('home')->orderBy('order')->get();
        $data['banners'] = Slider::active()->whereType('banner')->orderBy('order')->get();
        $data['pop'] = Slider::active()->whereType('pop')->orderBy('order')->first();
        
        $data['categories'] = Category::whereNull('parent_id')
        ->where('link_en', '!=','collections')
        ->active()
        ->get();

        $data['new_collection_products'] = Product::with(['variants.values.value.attribute', 'images','variants.images'])
        ->featured()
        ->home()
        ->take(8)
        ->active()
        ->get()
        ->shuffle();


        $data['collection_category'] = Category::with('subcategories')
            ->where('link_en', 'collections')
            ->orWhere('link_ar', 'collections')
            ->active()
            ->first();

        $data['best_selling_products'] = OrderItem::with([
            'product.images',
            'product.variants.images',
            'product.variants.values.value.attribute'
            ])
            ->groupBy('product_id')
            ->take(8)
            ->get()
            ->map(function ($item) {
                return $item->product;
            });


       



        $data['about'] = About::first();


        $data['aboutStrucs'] = AboutStruc::active()->take(6)->get();

        $data['pages'] = Page::active()->get();

        $data['offers'] = Product::active()->take(10)->whereHas('discounts')->inRandomOrder()->get();
        $data['products'] = Product::active()->take(8)->get()->shuffle();
        $data['partners'] = Partner::active()->orderBy('id','desc')->get();




        list($data['schema'], $data['metatags']) = $this->homePageSeo();

        return view('website.home', $data);
    }
}
