<?php

namespace App\Http\Controllers\website;

use App\Http\Controllers\Controller;
use App\Models\Area;
use App\Models\City;
use App\Models\Country;
use App\Models\PaymentMethod;
use App\Models\Governorate;
use App\Traits\Carts\CartTrait;
use App\Traits\Carts\GuestCartTrait;
use App\Traits\Checkout\CouponTrait;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

use function PHPUnit\Framework\isEmpty;

class CheckoutController extends Controller
{

    use CartTrait, GuestCartTrait,  CouponTrait;

    public function getCheckout(Request $request)
    {
        $request->validate([
            'cart_id' => ['nullable', 'exists:carts,id', 'integer'],
            'terms_conditions_check' => ['nullable', 'in:1']
        ]);

        $cart = Auth::check() ? $this->getCart() : $this->getGuestCart();

        $data['countries'] = Country::where('status', 1)->get();

        $data['governorates'] = Governorate::where('status', true)->get();

        $data['free_shipping'] = $cart->total_price >= config('site_free_amount', 0);

        if($data['free_shipping']){
            $data['grand_total'] = round($cart->total_price);
        } else {
            $data['grand_total'] = round($cart->total_price + config('site_standard_shipping_fees', 0));
        }

        if ($cart->items->isEmpty()) {
            return redirect()->route('website.home')->with('error', __('website.cart_is_empty'));
        }

        return view('website.checkout', $data);
    }


    public function getGovernoratesByCountry($countryId)
    {
        $country = Country::find($countryId);

        $Governorates = Governorate::where(column: 'country_id', operator: $country->id)->get();

        return response()->json([
            'Governorates' => $Governorates
        ]);
    }

    public function getAreasByGovernorate($GovernorateId)
    {
        $Governorate = Governorate::find($GovernorateId);

        $cities = City::where('Governorate_id', $Governorate->id)->get();

        return response()->json([
            'cities' => $cities
        ]);
    }


    public function getShippingFees(Request $request)
    {

        $governorateId = $request->governorate_id;


        // Logic to calculate shipping fees based on Governorate and area


        if ($governorateId) {
            $governorate = Governorate::find($governorateId);
            $governorateFees = $governorate ? $governorate->shipping_fees : 0;
            $governorateRequestSimpleShippingFees = $governorate ? $governorate->simple_request_shipping_fees : 0;
           
        }



        if (Auth::check()) {
            $cart = $this->getCart();
        } else {
            $cart = $this->getGuestCart();
        }

        $data['free_shipping'] = $cart->total_price >= config('site_free_amount', 0);

        if($data['free_shipping']) {
            $grand_total = $cart->total_price;
        } else {

            $grand_total = $cart->total_price + round($governorateFees);
        }





        return response()->json([
            'shipping_fees' => $governorateFees,
            'grand_total' =>  $grand_total,
            'simple_request_shipping_fees'=> $governorateRequestSimpleShippingFees,
            'currency' => config('app.currency') // Replace with your currency
        ]);
    }

    public function ApplyCoupon(Request $request)
    {

        // Get the coupon code from the request
        $couponCode = $request->input('couponCode');

        $cart = auth()->check() ? $this->getCart() : $this->getGuestCart();

        return  CouponTrait::applyCoupon($cart, $couponCode);
    }
}
