<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Http\Requests\StoreSiteAddressRequest;
use App\Http\Requests\UpdateSiteAddressRequest;
use App\Models\SiteAddress;
use Illuminate\Http\Request;

class SiteAddressController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        //
        $addresses = SiteAddress::all();

        return view('admin.siteAddresses.index', compact('addresses'));
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        return view('admin.siteAddresses.create');
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(StoreSiteAddressRequest $request)
    {
        $data = $request->validated();

        SiteAddress::create($data);

        return redirect('admin/site-addresses')->with('success', trans('home.your_item_added_successfully'));
    }


    /**
     * Show the form for editing the specified resource.
     */
    public function edit(SiteAddress $siteAddress)
    {
        return view('admin.siteAddresses.edit', compact('siteAddress'));
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(UpdateSiteAddressRequest $request, SiteAddress $siteAddress)
    {
        $date = $request->validated();
        if(!isset( $date['status'])){
            $date['status'] = 0;
        }
        $siteAddress->update($date);
        return redirect()->back()->with('success', trans('home.your_item_updated_successfully'));
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(SiteAddress $siteAddress)
    {
        if (request('id')) {
            $ids =  request('id');
            $ids = is_array($ids) ?    $ids  : [$ids];
            SiteAddress::whereIn('id', $ids)->delete();
            if (request()->ajax()) {
                return response()->json(['message' => trans('home.your_items_deleted_successfully')]);
            }
            return redirect()->back()->with('success', trans('home.your_items_deleted_successfully')); {
            }
        } elseif ($siteAddress) {
            $siteAddress->delete();
            if (request()->ajax()) {
                return response()->json(['message' => trans('home.your_item_deleted_successfully')]);
            }
            return redirect()->back()->with('success', trans('home.your_item_deleted_successfully'));
        }
    }
}
