<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Http\Requests\SettingRequest;
use Illuminate\Http\Request;
use App\Models\Setting;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Cache;

class SettingController extends Controller
{
    public function __construct(){
        $this->middleware(['permission:settings']);
    }

    public function index()
    {
        return view('admin.settings.setting');
    }

    public function update(SettingRequest $request, $id)
    {
        try {
            DB::beginTransaction();
        
            $data = $request->validated() ;

           
            foreach ($data as $key => $value) {
                foreach ($data as $key => $value) {
                    Setting::updateOrCreate(
                        ['key' => $key, 'lang' => 'all'], 
                        ['value' => $value]
                    );
                }
            }
            Cache::forget("settings");
            DB::commit();
         

            return redirect()->back()->with('success',trans('home.settings_updated_successfully'));

        } catch (\Exception $ex) {
           DB::rollBack() ;
           return redirect()->back()->withErrors($ex->getMessage());
        }

    }

}
