<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\SeoAssistant;
class SeoAssistantController extends Controller
{

    public function __construct()
    {
        $this->middleware('permission:seo');
    }

    public function index()
    {
        $seo = SeoAssistant::first();
    
        if (!$seo) {
            $seo = SeoAssistant::create([]);
        }
        return view('admin.seo.seo', compact('seo'));
    }

    public function update(Request $request)
    {
        $data = $request->all();

        $add = SeoAssistant::first();
        
        if (!$add) {
            $add = SeoAssistant::create([]);
        }
        $add->updateOrCreate(['id' => $add->id],  $data);

        return back()->with('success', trans('home.data_updated_successfully'));
    }
}
