<?php

namespace App\Http\Controllers\Admin\Products;

use App\Http\Controllers\Controller;
use App\Http\Requests\Admin\ProductsVariants\StoreVariantRequest;
use App\Http\Requests\Admin\ProductsVariants\UpdateVariantRequest;
use App\Models\Product;
use App\Models\ProductVariant ;
use App\Services\ProductServices\VariantService;
use Illuminate\Http\Request;

class ProductVariantController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index(Product $product)
    {
        // Fetch all product attributes with their associated attribute and values
        $data['product_attributes'] = $product->attributes()->with('attribute.values')->get();

        // Fetch all variants for the given product
        $data['product'] = $product;
        $product->load('variants.values.value'); // Eager load the variants with their values
        $data['variants'] = $product->variants()->with('values.value')->get();



        return view('admin.products.variants.index', $data);
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create(Product $product)
    {
        // Pass the product
        $data['product'] = $product;

        // Show the form to create a new variant
        return view('admin.products.variants.create', $data);
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(StoreVariantRequest $request , Product $product , VariantService $service)
    {
        try{
            $data = $request->validated();

            $service->store($data , $product);
            return redirect()->back()->with('success', __('home.your_items_added_successfully'));
        }catch (\Exception $e) {
            return redirect()->back()->with('error', $e->getMessage());
        }
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(UpdateVariantRequest $request , Product $product ,ProductVariant $variant , VariantService $service)
    {
        try{
            $data = $request->validated();

            $service->update($data , $product ,$variant);

            return redirect()->back()->with('success', __('home.variant_updated_successfully'));
        }catch (\Exception $e) {
            return redirect()->back()->with('error', $e->getMessage());
        }
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy( Product $product, ProductVariant $variant)
    {
        try {
            $variant->delete();

            return redirect()->back()->with('success', __('home.variant_deleted_successfully'));
        } catch (\Exception $e) {
            return redirect()->back()->with('error', $e->getMessage());
        }
    }
}
