<?php

namespace App\Http\Controllers\Admin\Products;

use App\Http\Controllers\Controller;
use App\Http\Requests\ProductsDiscounts\StoreProductDiscountRequest;
use App\Http\Requests\ProductsDiscounts\UpdateProductDiscountRequest;
use App\Models\Product;
use App\Models\ProductDiscount;
use Illuminate\Http\Request;

class ProductDiscountController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index(Product $product)
    {

        return view('admin.products.discounts.index', [
            'product' => $product->load('variants.values.value'),
            'discounts' => $product->discounts()->with('variant.values.value')->latest()->get(),
        ]);
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(StoreProductDiscountRequest $request,Product $product)
    {

        try{
            $validatedData = $request->validated();

            $validatedData['product_id'] = $product->id;

            ProductDiscount::create($validatedData);

            return redirect()->back()->with('success', __('home.your_items_added_successfully'));

        }catch (\Exception $e) {
            return redirect()->back()->with('error', $e->getMessage());
        }
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(Product $product , ProductDiscount $discount)
    {
        $data['product'] =  $product->load('variants.values.value');
        $data['discount'] = $discount;
        return view('admin.products.discounts.edit',$data);
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(UpdateProductDiscountRequest $request, Product $product , ProductDiscount $discount)
    {
        try{
            $validatedData = $request->validated();
            $validatedData['is_active'] = $validatedData['is_active'] ?? false;


            $discount->update($validatedData);

            return redirect()->route('products.discounts.index',$product->id)->with('success', __('home.your_items_updated_successfully'));

        }catch (\Exception $e) {
            return redirect()->back()->with('error', $e->getMessage());
        }
    }


    /**
     * Remove the specified resource from storage.
     */
    public function destroy( Product $product, ProductDiscount $discount)
    {
        try {
            $discount->delete();

            return redirect()->back()->with('success', __('home.discount_deleted_successfully'));
        } catch (\Exception $e) {
            return redirect()->back()->with('error', $e->getMessage());
        }
    }
}
