<?php

namespace App\Http\Controllers\Admin;

use App\Helpers\SaveImageTo3Path;
use App\Http\Controllers\Controller;
use App\Models\PaymentMethod;
use DB;
use File;
use Image;
use Illuminate\Http\Request;

class PaymentMethodController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */

    public function __construct()
    {
        // $this->middleware(['permission:payment_methods']);
    }

    public function index()
    {
        $paymentMethods = PaymentMethod::orderBy('id', 'DESC')->get();
        return view('admin.paymentMethods.paymentMethods', compact('paymentMethods'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return view('admin.paymentMethods.addPaymentMethod');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {

        $data = $request->all();


        if ($request->hasFile("logo")) {
            $saveImage = new SaveImageTo3Path(request()->file('logo'), true);
            $fileName = $saveImage->saveImages('paymentMethods');
            $data['logo'] = $fileName;
        }


        PaymentMethod::create($data);


        return redirect('admin/payment-methods')->with('success', trans('home.your_item_added_successfully'));
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $paymentMethod = PaymentMethod::find($id);
        if ($paymentMethod) {
            return view('admin.paymentMethods.editPaymentMethod', compact('paymentMethod'));
        } else {
            abort('404');
        }
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $add = PaymentMethod::find($id);
        $data = $request->all();
        
        if (isset($data['status'])) {
            $data['status'] = 1;
        } else {
            $data['status'] = 0;
        }

        if ($request->hasFile("logo")) {
           
            $saveImage = new SaveImageTo3Path(request()->file('logo'),true);
            $fileName = $saveImage->saveImages('paymentMethods');
            SaveImageTo3Path::deleteImage($add->logo,'paymentMethods');
            $data['logo'] = $fileName;
        }

        $add->update($data);

        return redirect('/admin/payment-methods')->with('success', trans('home.your_item_updated_successfully'));
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        if (request('id')) {
            request()->validate([
                'id' => 'array|min:1|',
                'id.*' => 'exists:payment_methods,id'
            ]);
            $ids =  request('id');
            $delete = PaymentMethod::whereIn('id', $ids)->delete();
            // check if comming from ajax
            if (request()->ajax()) {
                // check is is deleted or has any exception
                if (!$delete) {
                    return response()->json(['message' => $delete ?? __('home.an messages.error entering data')], 422);
                }
                return response()->json(['message' => trans('home.your_items_deleted_successfully')]);
            }
            if (!$delete) {
                return redirect()->back()->withErrors($delete ?? __('home.an messages.error entering data'));
            }
            return redirect()->back()->with('success', trans('home.your_items_deleted_successfully'));
        }
    }
}
