<?php

namespace App\Http\Controllers\Admin;

use App\Helpers\Media;
use App\Http\Controllers\Controller;
use App\Http\Requests\StorePartnerRequest;
use App\Models\Partner;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class PartnerController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        $partners = Partner::orderBy('id', 'desc')->get();
        return view('admin.partners.index', compact('partners'));
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        return view('admin.partners.create');
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(StorePartnerRequest $request)
    {
        $validatedData = $request->validated();

        DB::beginTransaction();
        try {

           
            if ($request->has('logo')) {
                $validatedData['logo'] = Media::uploadAndAttachImage($request->file('logo'), 'partners');
            }

            Partner::create($validatedData);

            DB::commit();
            return redirect()->route('partners.index')->with('success', trans('home.your_item_added_successfully'));
        } catch (\Exception $e) {
            DB::rollBack();
            return redirect()->back()->with(['error' => $e->getMessage()]);
        }
    }


    /**
     * Show the form for editing the specified resource.
     */
    public function edit(Partner $partner)
    {
        return view('admin.partners.edit', compact('partner'));
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(StorePartnerRequest $request, Partner $partner)
    {
        $validatedData = $request->validated();

        $data['status'] = $data['status'] ?? 0;

        DB::beginTransaction();
        
        try {
            if ($request->has('logo')) {
                if ($partner->logo) {
                    Media::removeFile('partners', $partner->logo);
                }

                $validatedData['logo'] = Media::uploadAndAttachImage($request->file('logo'), 'partners');
            }

            $partner->update($validatedData);

            DB::commit();
            return redirect()->route('partners.index')->with('success', trans('home.your_item_updated_successfully'));  
        } catch (\Exception $e) {
            DB::rollBack();
            return redirect()->back()->with(['error' => $e->getMessage()]);
        }
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(Request $request)
    {

        $selectedIds = $request->input('id');

        $partners = Partner::whereIn('id', $selectedIds)->get();

        DB::beginTransaction();
        try {
            foreach ($partners as $partner) {
              
                // Delete associated Icon if it exists
                if ($partner->logo) {
                    Media::removeFile('partners', $partner->logo);
                }
            }
            Partner::whereIn('id', $selectedIds)->delete();

            DB::commit();

            return response()->json(['success' => true, 'message' => __('home.your_items_deleted_successfully')]);
        } catch (\Exception $e) {

            DB::rollBack();
            return response()->json(['error' => true, 'message' => __('home.an error has occurred. Please contact the developer to resolve the issue')]);
        }
    }
}
