<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\InspectionRequest;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class InspectionRequestController extends Controller
{
    public function index()
    {

        $inspectionRequests = InspectionRequest::orderBy('created_at', 'desc')->get();

        return view('admin.InspectionRequests.index', compact('inspectionRequests'));
    }
    public function show(InspectionRequest $inspectionRequest)
    {
        return view('admin.InspectionRequests.show', compact('inspectionRequest'));
    }

    public function destroy(Request $request)
    {


        // Validate the request
        $request->validate([
            'id' => 'required|array|min:1',
            'id.*' => 'integer|exists:inspection_requests,id',
        ]);

        $selectedIds = $request->input('id');

        DB::beginTransaction();
        try {

            // Delete the messages
            $deleted = InspectionRequest::whereIn('id', $selectedIds)->delete();

            DB::commit();

            // Handle AJAX requests
            if ($request->ajax()) {
                return response()->json([
                    'success' => true,
                    'message' => __('home.your_items_deleted_successfully'),
                ]);
            }

            // Redirect for non-AJAX requests
            return redirect()->route('home.contact_messages.index')
                ->with('success', __('home.your_items_deleted_successfully'));
        } catch (\Exception $e) {
            DB::rollBack();

            // Log the error for debugging
            \Log::error('Error deleting contact messages: ' . $e->getMessage());

            // Handle AJAX requests
            if ($request->ajax()) {
                return response()->json([
                    'success' => false,
                    'message' => __('home.an_error_occurred'),
                ], 500);
            }

            // Redirect for non-AJAX requests
            return redirect()->back()
                ->withErrors(__('home.an_error_occurred'));
        }
    }
}
