<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Country;
use File;
use Image;
use Illuminate\Http\Request;

class CountryController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */

    public function __construct(){
        $this->middleware(['permission:countries']);
    }

    public function index()
    {
        //
        $countries = Country::orderBy('id','DESC')->get();
        return view('admin.countries.countries',compact('countries'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
        return view('admin.countries.addCountry');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $data = $request->all();
        Country::create($data);
        return redirect('admin/countries')->with('success',trans('home.your_item_added_successfully'));
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
        $country=Country::find($id);
        return view('admin.countries.editCountry',compact('country'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
        $add = Country::find($id);
       
        $data = $request->all();

        if (isset($data['status'])) {
            $data['status'] = 1;
        } else {
            $data['status'] = 0;
        }

        $add->update($data);

        $add->save();
        return redirect('admin/countries')->with('success',trans('home.your_item_updated_successfully'));
    }


    public function destroy($ids)
    {
        //
        $ids = explode(',', $ids);
        if ($ids[0] == 'on') {
            unset($ids[0]);
        }

        $country = Country::whereIn('id',$ids)->CheckBeforDelete()->get();
        if(count($country) > 0){
            if (request()->ajax()) {
                return  response()->json(['message'=>__('home.the item cannot be deleted. There is data related to it')],402);
            }
            return redirect()->back()->withErrors(__('home.the item cannot be deleted. There is data related to it'));
        }
        foreach ($ids as $id) {
            $country = Country::findOrFail($id)->delete();
        }
    }
}
