<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Http\Requests\AttributeValueRequest;
use App\Models\Attribute;
use App\Models\AttributeValue;
use Illuminate\Http\Request;

class AttributeValueController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function create(Attribute $attribute)
    {
        
        return view('admin.attribute-values.create', compact('attribute'));
    }


    /**
     * Store a newly created resource in storage.
     */
    public function store(AttributeValueRequest $request , Attribute $attribute)
    {
        $data = $request->validated();
        $data['status'] = $data['status'] ?? 0;
        $data['attribute_id'] = $attribute->id;
     
        $attribute->values()->create($data);

        return redirect()->route('attributes.edit', $attribute->id)
            ->with('success', __('admin.attribute_value_created_successfully'));
    }
  


    /**
     * Update the specified resource in storage.
     */
    public function update(AttributeValueRequest $request,  Attribute $attribute, AttributeValue $value)
    {
        
        $data = $request->validated();
        $data['status'] = $data['status'] ?? 0;
        $value->update($data);

        return redirect()->route('attributes.edit', $attribute->id)
            ->with('success', __('admin.attribute_value_updated_successfully'));
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(Attribute $attribute, AttributeValue $value)
    {
        $value->delete();

        return redirect()->route('attributes.edit', $attribute->id)
            ->with('success', __('admin.attribute_value_deleted_successfully'));
    }
}
