<?php

namespace App\Http\Controllers\Admin;

use App\Helpers\Media;
use App\Helpers\SaveImageTo3Path;
use App\Http\Controllers\Controller;
use App\Http\Requests\AboutStrucRequest;
use App\Models\AboutStruc;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class AboutStrucController extends Controller
{

    public function __construct()
    {
        $this->middleware(['permission:aboutStrucs']);
    }
    public function index()
    {

        $data['aboutStrucs'] = AboutStruc::get();

        return view('admin.aboutStrucs.aboutStrucs', $data);
    }


    public function create()
    {
        $data['aboutStrucs'] = AboutStruc::get();
        return view('admin.aboutStrucs.addAboutStruc');
    }


    public function store(AboutStrucRequest $request)
    {
        DB::beginTransaction();
        try {

            $data  = $request->validated();

            if ($request->has('image')) {
                $data['image'] = Media::uploadAndAttachImage($request->file('image'), 'aboutStrucs');
            }

            AboutStruc::create($data);
            DB::commit();
            return redirect()->back()->with('success', trans('home.your_item_added_successfully'));
        } catch (\Exception $e) {
            DB::rollBack();
            return redirect()->back()->with(['error' => $e->getMessage()]);
        }
    }


    public function edit(AboutStruc $aboutStruc)
    {

        return view('admin.aboutStrucs.editAboutStruc', compact('aboutStruc'));
    }


    public function update(AboutStrucRequest $request,  AboutStruc $aboutStruc)
    {


        DB::beginTransaction();
        try {

            $data = $request->validated();

            $data['status'] = $data['status'] ?? 0;


            if ($request->hasFile('image')) {
                if ($aboutStruc->image) {
                    Media::removeFile('aboutStrucs', $aboutStruc->image);
                }
                $data['image'] = Media::uploadAndAttachImage($request->file('image'), 'aboutStrucs');
            }

            $aboutStruc->update($data);
            DB::commit();

            return redirect()->back()->with('success', trans('home.your_item_updated_successfully'));
        } catch (\Exception $e) {
            DB::rollBack();
            return redirect()->back()->with(['error' => $e->getMessage()]);
        }
    }


    public function destroy(Request $request)
    {

        $selectedIds = $request->input('id');

        $aboutStrucs = AboutStruc::whereIn('id', $selectedIds)->get();

        DB::beginTransaction();
        try {
            foreach ($aboutStrucs as $aboutStruc) {
                // Delete associated image if it exists
                if ($aboutStruc->image) {
                    Media::removeFile('aboutStrucs', $aboutStruc->image);
                }
            }
            AboutStruc::whereIn('id', $selectedIds)->delete();

            DB::commit();

            return response()->json(['success' => true, 'message' => __('home.your_items_deleted_successfully')]);
        } catch (\Exception $e) {

            DB::rollBack();

            return response()->json(['error' => true, 'message' => __('home.an error has occurred. Please contact the developer to resolve the issue')]);
        }
    }
}
