<?php

namespace App\Exports;

use App\Models\Order;
use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\WithHeadings;
use Maatwebsite\Excel\Concerns\WithMapping;

class OrdersReportExport implements FromCollection ,WithHeadings, WithMapping
{

    protected $orders;

    
    public function __construct($orders)
    {
        $this->orders = $orders;
    }


    /**
    * @return \Illuminate\Support\Collection
    */
    public function collection()
    {
       return $this->orders;
    }

    public function headings(): array
    {
        return [
            'ID',
            'Order Number',
            'Date',
            'Customer',
            'Email',
            'Phone',
            'Total Amount',
            'Status',
            'Payment Method',
            'Products',
            'Address'
        ];
    }

    public function map($order): array
    {
    
        return [
            $order->id,
            $order->order_number,
            $order->created_at->format('Y-m-d'),
            $order->user->f_name . ' ' . $order->user->l_name,
            $order->user->email,
            $order->address?->phone ?? 'N/A',
            $order->total_amount,
            $order->status->name,
            $order->payment->paymentMethod->name ?? 'N/A',
            $order->items->map(function ($item) {
                return $item->product->name . ' (Qty: ' . $item->quantity . ')';
            })->implode(', '),
            $order->full_address ?? 'N/A'
        ];
    }
}
