<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use Illuminate\Support\Facades\DB;

class MigrateOldProducts extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'app:migrate-old-products';
  

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Migrate products from old DB to new DB';

    /**
     * Execute the console command.
     */
    public function handle()
    {
        DB::connection('mysql_old')->disableQueryLog();

        $products = DB::connection('mysql_old')
            ->table('products')
            ->select(
                'id', 
                'name_ar',
                'name_en',
                'link_ar',
                'link_en',
                'price',
                'stock',
                'ordered',
                'visits',
                'code',
                'category_id',
                'status',
                'featurd',
                'home',
                'short_desc_en',
                'short_desc_ar',
                'long_desc_en',
                'long_desc_ar',
                'meta_title_en',
                'meta_title_ar',
                'meta_desc_en',
                'meta_desc_ar',
                'meta_robots',
                'created_at',
                'updated_at'
            )->get();

        foreach ($products as $old) {
            // Generate unique slugs
            $linkAr = $this->generateUniqueSlug($old->link_ar, 'link_ar');
            $linkEn = $this->generateUniqueSlug($old->link_en, 'link_en');

            DB::table('products')->insert([
                'id' => $old->id,
                'name_ar' => $old->name_ar,
                'name_en' => $old->name_en,
                'code' => $old->code,
                'category_id' => $old->category_id,
                'viewing_count' => $old->visits ?? 0,
                'order' => $old->ordered ?? 0,
                'price' => $old->price,
                'quantity' => $old->stock,
                'short_text_ar' => $old->short_desc_ar,
                'short_text_en' => $old->short_desc_en,
                'text_ar' => $old->long_desc_ar,
                'text_en' => $old->long_desc_en,
                'alt_main_image' => $old->name_ar,
                'alt_second_image' => $old->name_en,
                'status' => $old->status ?? 1,
                'featured' => $old->featurd ?? 0,
                'home' => $old->home ?? 0,
                'link_ar' => $linkAr,
                'link_en' => $linkEn,
                'meta_title_ar' => $old->meta_title_ar,
                'meta_title_en' => $old->meta_title_en,
                'meta_description_ar' => $old->meta_desc_ar,
                'meta_description_en' => $old->meta_desc_en,
                'index' => $old->meta_robots ?? 0,
                'created_at' => $old->created_at,
                'updated_at' => $old->updated_at,
            ]);

            $this->info("Inserted product: {$old->name_ar} [link_ar: $linkAr]");
        }

        $this->info('✅ Product migration complete.');
    }

    private function generateUniqueSlug($baseSlug, $column = 'link_ar')
    {
        $slug = $baseSlug;
        $count = 1;

        while (DB::table('products')->where($column, $slug)->exists()) {
            $slug = $baseSlug . '-' . $count++;
        }

        return $slug;
    }
}
