<?php if (isset($component)) { $__componentOriginalcbd4b493d51bfac881dfb1e0f199e331 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginalcbd4b493d51bfac881dfb1e0f199e331 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.dashboard.layout','data' => ['title' => __('dashboard.edit') . $project->name]] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('dashboard.layout'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['title' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute(__('dashboard.edit') . $project->name)]); ?>

    <?php $__env->startSection('style'); ?>
        <style>
            .sortable-container {
                cursor: move;
            }

            .sortable-container.sortable-ghost {
                opacity: 0.5;
            }

            .sortable-container.sortable-chosen {
                background-color: #f8f9fa;
                border: 2px dashed #007bff;
            }

            .drag-handle {
                cursor: move;
                position: absolute;
                top: 5px;
                right: 5px;
                background: rgba(0, 0, 0, 0.5);
                color: white;
                padding: 2px 6px;
                border-radius: 3px;
                font-size: 12px;
            }
        </style>
    <?php $__env->stopSection(); ?>

    <!-- Enhanced Page Header -->
    <div class="enhanced-page-header">
        <div class="row align-items-center">
            <div class="col-md-8">
                <h4><?php echo e(__('dashboard.edit') . $project->name); ?></h4>
            </div>
            <div class="col-md-4">
                <nav aria-label="breadcrumb">
                    <ol class="breadcrumb">
                        <li class="breadcrumb-item"><a href="<?php echo e(route('dashboard.home')); ?>">Dashboard</a></li>
                        <li class="breadcrumb-item"><a
                                href="<?php echo e(route('dashboard.projects.index')); ?>"><?php echo e(__('dashboard.projects')); ?></a></li>
                        <li class="breadcrumb-item active"><?php echo e(__('dashboard.edit')); ?></li>
                    </ol>
                </nav>
            </div>
        </div>
    </div>
    <!-- End Enhanced Page Header -->


    <!-- Enhanced Form Container -->
    <div class="enhanced-form-container">

        <form action="<?php echo e(route('dashboard.projects.update', [$project->id])); ?>" method="POST"
            enctype="multipart/form-data" id="project-update-form">
            <?php echo csrf_field(); ?>
            <?php echo method_field('PATCH'); ?>

            <!-- Basic Information Section -->
            <div class="enhanced-section">
                <h4><i class="fas fa-info-circle me-2"></i><?php echo e(__('dashboard.basic_information')); ?></h4>
                <div class="row">

                    <div class="form-group col-md-4 enhanced-form-group">
                        <label><?php echo e(__('dashboard.name_en')); ?></label>
                        <input class="form-control" name="name_en" type="text" value="<?php echo e($project->name_en); ?>"
                            placeholder="<?php echo e(__('dashboard.name_en')); ?>">
                    </div>

                    <div class="form-group col-md-4 enhanced-form-group">
                        <label><?php echo e(__('dashboard.name_ar')); ?></label>
                        <input class="form-control" name="name_ar" type="text" value="<?php echo e($project->name_ar); ?>"
                            placeholder="<?php echo e(__('dashboard.name_ar')); ?>">
                    </div>

                    <div class="form-group col-md-2 enhanced-form-group">
                        <label><?php echo e(__('dashboard.order')); ?></label>
                        <input class="form-control" name="order" type="number" value="<?php echo e($project->order); ?>"
                            placeholder="<?php echo e(__('dashboard.order')); ?>">
                    </div>

                    <div class="form-group col-md-2 enhanced-form-group">
                        <label for="parent"><?php echo e(__('dashboard.parent')); ?></label>
                        <select class="form-control select2" name="parent_id">
                            <option value=""><?php echo e(__('dashboard.no_parent')); ?></option>
                            <?php $__currentLoopData = $projects; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $projectItem): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($projectItem->id); ?>"
                                    <?php echo e(old('parent_id', $project->parent_id) == $projectItem->id ? 'selected' : ''); ?>>
                                    <?php echo e($projectItem->name); ?>

                                </option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                        <?php if($project->parent): ?>
                            <div class="mt-2 text-info">
                                <small><?php echo e(__('dashboard.current_parent')); ?>:
                                    <b><?php echo e($project->parent->name); ?></b></small>
                            </div>
                        <?php endif; ?>
                    </div>
                </div>
            </div>

            <!-- Images Section -->
            <div class="enhanced-section">
                <h4><i class="fas fa-images me-2"></i><?php echo e(__('dashboard.images')); ?></h4>
                <div class="row">
                    <div class="form-group col-md-5 enhanced-form-group">
                        <label><?php echo e(__('dashboard.image')); ?> (225px * 225px max 1mb)</label>
                        <div class="enhanced-file-input">
                            <input type="file" name="image" accept="image/*">
                            <label for="image" class="file-input-label">
                                <i class="fas fa-upload"></i>
                                <?php echo e(__('dashboard.choose_file')); ?>

                            </label>
                        </div>
                    </div>

                    <div class="form-group col-md-5 enhanced-form-group">
                        <label><?php echo e(__('dashboard.image_preview')); ?></label>
                        <div class="enhanced-image-preview">
                            <?php if($project->image_path): ?>
                                <img src="<?php echo e($project->image_path); ?>" alt="<?php echo e($project->name); ?>">
                                <div class="image-overlay">
                                    <i class="fas fa-eye"></i>
                                </div>
                            <?php else: ?>
                                <div class="enhanced-no-image">
                                    <i class="fas fa-image"></i>
                                    <span><?php echo e(__('dashboard.no_image_available')); ?></span>
                                </div>
                            <?php endif; ?>
                        </div>
                    </div>

                    <div class="form-group col-md-2 enhanced-form-group">
                        <label><?php echo e(__('dashboard.alt_image')); ?></label>
                        <input class="form-control" name="alt_image" type="text"
                            placeholder="<?php echo e(__('dashboard.alt_image')); ?>" value="<?php echo e($project->alt_image); ?>">
                    </div>

                    <div class="form-group col-md-5 enhanced-form-group">
                        <label><?php echo e(__('dashboard.icon')); ?> (50px * 50px max 1mb)</label>
                        <div class="enhanced-file-input">
                            <input type="file" name="icon" accept="image/*" id="icon-input">
                            <label for="icon-input" class="file-input-label">
                                <i class="fas fa-upload"></i>
                                <?php echo e(__('dashboard.choose_file')); ?>

                            </label>
                        </div>
                    </div>

                    <div class="form-group col-md-5 enhanced-form-group">
                        <label><?php echo e(__('dashboard.icon_preview')); ?></label>
                        <div class="enhanced-image-preview">
                            <?php if($project->icon_path): ?>
                                <img src="<?php echo e($project->icon_path); ?>" alt="<?php echo e($project->name); ?>">
                                <div class="image-overlay">
                                    <i class="fas fa-eye"></i>
                                </div>
                            <?php else: ?>
                                <div class="enhanced-no-image">
                                    <i class="fas fa-image"></i>
                                    <span><?php echo e(__('dashboard.no_image_available')); ?></span>
                                </div>
                            <?php endif; ?>
                        </div>
                    </div>

                    <div class="form-group col-md-2 enhanced-form-group">
                        <label><?php echo e(__('dashboard.alt_icon')); ?></label>
                        <input class="form-control" name="alt_icon" type="text"
                            placeholder="<?php echo e(__('dashboard.alt_icon')); ?>" value="<?php echo e($project->alt_icon); ?>">
                    </div>
                </div>
            </div>



            <!-- Descriptions Section -->
            <div class="enhanced-section">
                <h4><i class="fas fa-align-left me-2"></i><?php echo e(__('dashboard.descriptions')); ?></h4>
                <div class="row">
                    <div class="form-group col-md-6 enhanced-form-group">
                        <label><?php echo e(__('dashboard.short_desc_en')); ?></label>
                        <textarea class="form-control" name="short_desc_en" type="text" placeholder="<?php echo e(__('dashboard.short_desc_en')); ?>"><?php echo $project->short_desc_en; ?></textarea>
                    </div>

                    <div class="form-group col-md-6 enhanced-form-group">
                        <label><?php echo e(__('dashboard.short_desc_ar')); ?></label>
                        <textarea class="form-control" name="short_desc_ar" type="text"
                            placeholder="<?php echo e(__('dashboard.short_desc_ar')); ?>"><?php echo $project->short_desc_ar; ?></textarea>
                    </div>

                    <div class="form-group col-md-6 enhanced-form-group">
                        <label><?php echo e(__('dashboard.long_desc_en')); ?></label>
                        <textarea class="form-control" id="myeditorinstance" name="long_desc_en" type="text"
                            placeholder="<?php echo e(__('dashboard.long_desc_en')); ?>"><?php echo $project->long_desc_en; ?></textarea>
                    </div>

                    <div class="form-group col-md-6 enhanced-form-group">
                        <label><?php echo e(__('dashboard.long_desc_ar')); ?></label>
                        <textarea class="form-control" id="myeditorinstance" name="long_desc_ar" type="text"
                            placeholder="<?php echo e(__('dashboard.long_desc_ar')); ?>"><?php echo $project->long_desc_ar; ?></textarea>
                    </div>
                </div>
            </div>
            <!-- Project Details Section -->
            <div class="enhanced-section">
                <h4><i class="fas fa-project-diagram me-2"></i><?php echo e(__('dashboard.project_details')); ?></h4>
                <div class="row">
                    <div class="form-group col-md-3 enhanced-form-group">
                        <label><?php echo e(__('dashboard.clients_en')); ?></label>
                        <input class="form-control" name="clients_en" type="text"
                            value="<?php echo e($project->clients_en); ?>" placeholder="<?php echo e(__('dashboard.clients_en')); ?>">
                    </div>

                    <div class="form-group col-md-3 enhanced-form-group">
                        <label><?php echo e(__('dashboard.location_en')); ?></label>
                        <input class="form-control" name="location_en" type="text"
                            value="<?php echo e($project->location_en); ?>" placeholder="<?php echo e(__('dashboard.location_en')); ?>">
                    </div>

                    <div class="form-group col-md-3 enhanced-form-group">
                        <label><?php echo e(__('dashboard.category_en')); ?></label>
                        <input class="form-control" name="category_en" type="text"
                            value="<?php echo e($project->category_en); ?>" placeholder="<?php echo e(__('dashboard.category_en')); ?>">
                    </div>

                    <div class="form-group col-md-3 enhanced-form-group">
                        <label><?php echo e(__('dashboard.service_en')); ?></label>
                        <input class="form-control" name="service_en" type="text"
                            value="<?php echo e($project->service_en); ?>" placeholder="<?php echo e(__('dashboard.service_en')); ?>">
                    </div>

                    <div class="form-group col-md-3 enhanced-form-group">
                        <label><?php echo e(__('dashboard.clients_ar')); ?></label>
                        <input class="form-control" name="clients_ar" type="text"
                            value="<?php echo e($project->clients_ar); ?>" placeholder="<?php echo e(__('dashboard.clients_ar')); ?>">
                    </div>

                    <div class="form-group col-md-3 enhanced-form-group">
                        <label><?php echo e(__('dashboard.location_ar')); ?></label>
                        <input class="form-control" name="location_ar" type="text"
                            value="<?php echo e($project->location_ar); ?>" placeholder="<?php echo e(__('dashboard.location_ar')); ?>">
                    </div>

                    <div class="form-group col-md-3 enhanced-form-group">
                        <label><?php echo e(__('dashboard.category_ar')); ?></label>
                        <input class="form-control" name="category_ar" type="text"
                            value="<?php echo e($project->category_ar); ?>" placeholder="<?php echo e(__('dashboard.category_ar')); ?>">
                    </div>

                    <div class="form-group col-md-3 enhanced-form-group">
                        <label><?php echo e(__('dashboard.service_ar')); ?></label>
                        <input class="form-control" name="service_ar" type="text"
                            value="<?php echo e($project->service_ar); ?>" placeholder="<?php echo e(__('dashboard.service_ar')); ?>">
                    </div>

                    <div class="form-group col-md-4 enhanced-form-group">
                        <label><?php echo e(__('dashboard.date')); ?></label>
                        <input class="form-control" name="date" type="date" value="<?php echo e($project->date); ?>"
                            placeholder="<?php echo e(__('dashboard.date')); ?>">
                    </div>
                </div>
            </div>
            <!-- Category Section -->
            <div class="enhanced-section">
                <h4><i class="fas fa-tags me-2"></i><?php echo e(__('home.edit_category')); ?></h4>
                <div class="row align-items-center mb-3">
                    <div class="col-md-10">
                        <div class="alert alert-warning">
                            <i class="fas fa-exclamation-triangle me-2"></i>
                            <?php echo e(__('home.changing category will change specifications values')); ?>

                        </div>
                    </div>
                    <div class="col-md-2 text-end">
                        <a type="button" class="btn enhanced-btn enhanced-btn-primary" data-bs-toggle="modal"
                            data-bs-target="#Modal1">
                            <i class="fas fa-edit me-2"></i><?php echo e(__('dashboard.edit')); ?>

                        </a>
                    </div>
                    <div class="col-md-12 mt-2">
                        <div class="form-group enhanced-form-group">
                            <select class="form-control select2" name="category_id" id="category_id">
                                <option value="<?php echo e($project->category_id); ?>">
                                    <?php echo e($project->category?->{'name_' . app()->getLocale()} ?? ''); ?>

                                </option>
                            </select>
                        </div>
                    </div>
                </div>

                <div class="form-group col-md-12 enhanced-form-group">
                    <label for="project_images"><?php echo e(__('dashboard.project_images')); ?></label>
                    <div class="enhanced-file-input">
                        <input type="file" name="project_images[]" multiple accept="image/*"
                            id="project-images-input">
                        <label for="project-images-input" class="file-input-label">
                            <i class="fas fa-upload"></i>
                            <?php echo e(__('dashboard.choose_files')); ?>

                        </label>
                    </div>
                </div>
            </div>
            <!-- Image Gallery Section -->
            <?php if(!empty($project->images) && $project->images->count() > 0): ?>
                <div class="enhanced-gallery-container">
                    <h4><i class="fas fa-images me-2"></i><?php echo e(__('dashboard.project_images')); ?></h4>
                    <div id="delete_selected_images_form">
                        <div class="d-flex flex-wrap mb-3 align-items-center gap-2">
                            <button type="button" id="select_all_btn" class="btn enhanced-btn enhanced-btn-primary">
                                <i class="fas fa-check-square me-2"></i><?php echo e(__('dashboard.select_all')); ?>

                            </button>
                            <button type="button" id="delete_selected_btn"
                                class="btn enhanced-btn enhanced-btn-danger">
                                <i class="fas fa-trash me-2"></i><?php echo e(__('dashboard.delete_selected')); ?>

                            </button>
                            <a href='#' data-id="<?php echo e($project->id); ?>"
                                class='delete_all_img btn enhanced-btn enhanced-btn-danger'>
                                <i class="fas fa-trash-alt me-2"></i><?php echo e(__('dashboard.delete_all')); ?>

                            </a>
                            <button type="button" id="save_order_btn" class="btn enhanced-btn enhanced-btn-success">
                                <i class="fas fa-save me-2"></i><?php echo e(__('dashboard.save_order')); ?>

                            </button>
                        </div>
                        <div class="col-md-12 mt-3">
                            <div class="row mb-0" id="sortable-images">
                                <?php $__currentLoopData = $project->images; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $image): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <div class="col-md-3 col-sm-6 mb-3 sortable-container"
                                        data-id="<?php echo e($image->id); ?>">
                                        <div class="enhanced-gallery-item">
                                            <div class="drag-handle">⋮⋮</div>
                                            <img class="card-img-top" src="<?php echo e($image->image_url); ?>"
                                                style="height: 200px; object-fit: cover;">
                                            <div class="card-body text-center">
                                                <input type="checkbox" name="selected_images[]"
                                                    value="<?php echo e($image->id); ?>" class="select_image_checkbox mb-2">
                                                <button type="button" data-image="<?php echo e($image->id); ?>"
                                                    class="delete_img_btn btn enhanced-btn enhanced-btn-danger btn-sm">
                                                    <i class="fas fa-trash me-1"></i><?php echo e(trans('dashboard.delete')); ?>

                                                </button>
                                            </div>
                                        </div>
                                    </div>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </div>
                        </div>
                    </div>
                </div>
            <?php endif; ?>
            <!-- Status Controls Section -->
            <div class="enhanced-section">
                <h4><i class="fas fa-toggle-on me-2"></i><?php echo e(__('dashboard.status_controls')); ?></h4>
                <div class="row">
                    <div class="form-group col-md-3">
                        <div class="enhanced-switch-container">
                            <h5><?php echo e(__('dashboard.publish/unpublish')); ?></h5>
                            <input type="checkbox" id="switch1" switch="none" value="1" name="status"
                                <?php if(old('status', $project->status)): echo 'checked'; endif; ?> />
                            <label for="switch1" data-on-label="<?php echo e(__('dashboard.yes')); ?>"
                                data-off-label="<?php echo e(__('dashboard.no')); ?>"></label>
                        </div>
                    </div>

                    <div class="form-group col-md-3">
                        <div class="enhanced-switch-container">
                            <h5><?php echo e(__('dashboard.show_in_home')); ?></h5>
                            <input type="checkbox" id="switch2" switch="none" value="1" name="show_in_home"
                                <?php if(old('show_in_home', $project->show_in_home)): echo 'checked'; endif; ?> />
                            <label for="switch2" data-on-label="<?php echo e(__('dashboard.yes')); ?>"
                                data-off-label="<?php echo e(__('dashboard.no')); ?>"></label>
                        </div>
                    </div>

                    <div class="form-group col-md-3">
                        <div class="enhanced-switch-container">
                            <h5><?php echo e(__('dashboard.show_in_header')); ?></h5>
                            <input type="checkbox" id="switch3" switch="none" value="1"
                                name="show_in_header" <?php if(old('show_in_header', $project->show_in_header)): echo 'checked'; endif; ?> />
                            <label for="switch3" data-on-label="<?php echo e(__('dashboard.yes')); ?>"
                                data-off-label="<?php echo e(__('dashboard.no')); ?>"></label>
                        </div>
                    </div>

                    <div class="form-group col-md-3">
                        <div class="enhanced-switch-container">
                            <h5><?php echo e(__('dashboard.show_in_footer')); ?></h5>
                            <input type="checkbox" id="switch4" switch="none" value="1"
                                name="show_in_footer" <?php if(old('show_in_footer', $project->show_in_footer)): echo 'checked'; endif; ?> />
                            <label for="switch4" data-on-label="<?php echo e(__('dashboard.yes')); ?>"
                                data-off-label="<?php echo e(__('dashboard.no')); ?>"></label>
                        </div>
                    </div>
                </div>
            </div>


            <!-- SEO Section -->
            <div class="enhanced-section">
                <h4><i class="fas fa-search me-2"></i><?php echo e(__('dashboard.seo')); ?></h4>
                <div class="row">
                    <div class="form-group col-md-2 enhanced-form-group">
                        <label><?php echo e(__('dashboard.slug_en')); ?></label>
                        <input type="text" autocomplete="off" class="form-control"
                            placeholder="<?php echo e(__('dashboard.slug_en')); ?>" name="slug_en"
                            value="<?php echo e($project->slug_en); ?>">
                    </div>

                    <div class="form-group col-md-5 enhanced-form-group">
                        <label><?php echo e(__('dashboard.meta_title_en')); ?></label>
                        <textarea class="form-control" name="meta_title_en" placeholder="<?php echo e(__('dashboard.meta_title_en')); ?>"><?php echo $project->meta_title_en; ?></textarea>
                    </div>

                    <div class="form-group col-md-5 enhanced-form-group">
                        <label><?php echo e(__('dashboard.meta_desc_en')); ?></label>
                        <textarea class="form-control" name="meta_desc_en" placeholder="<?php echo e(__('dashboard.meta_desc_en')); ?>"><?php echo $project->meta_desc_en; ?></textarea>
                    </div>

                    <div class="form-group col-md-2 enhanced-form-group">
                        <label><?php echo e(__('dashboard.slug_ar')); ?></label>
                        <input type="text" autocomplete="off" class="form-control"
                            placeholder="<?php echo e(__('dashboard.slug_ar')); ?>" name="slug_ar"
                            value="<?php echo e($project->slug_ar); ?>">
                    </div>

                    <div class="form-group col-md-5 enhanced-form-group">
                        <label><?php echo e(__('dashboard.meta_title_ar')); ?></label>
                        <textarea class="form-control" name="meta_title_ar" placeholder="<?php echo e(__('dashboard.meta_title_ar')); ?>"><?php echo $project->meta_title_ar; ?></textarea>
                    </div>

                    <div class="form-group col-md-5 enhanced-form-group">
                        <label><?php echo e(__('dashboard.meta_desc_ar')); ?></label>
                        <textarea class="form-control" name="meta_desc_ar" placeholder="<?php echo e(__('dashboard.meta_desc_ar')); ?>"><?php echo $project->meta_desc_ar; ?></textarea>
                    </div>

                    <div class="form-group col-md-12">
                        <div class="enhanced-switch-container">
                            <h5><?php echo e(__('dashboard.meta_robots')); ?> (index)</h5>
                            <input type="checkbox" id="switch5" switch="none" value="1" name="index"
                                <?php if(old('index', $project->index)): echo 'checked'; endif; ?> />
                            <label for="switch5" data-on-label="<?php echo e(__('dashboard.yes')); ?>"
                                data-off-label="<?php echo e(__('dashboard.no')); ?>"></label>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Enhanced Action Buttons -->
            <div class="enhanced-action-buttons text-center">
                <button type="submit" class="btn enhanced-btn enhanced-btn-success">
                    <i class="fas fa-save me-2"></i><?php echo e(__('dashboard.update')); ?>

                </button>
                <a href="<?php echo e(route('dashboard.projects.index')); ?>" class="btn enhanced-btn enhanced-btn-danger">
                    <i class="fas fa-times me-2"></i><?php echo e(__('dashboard.cancel')); ?>

                </a>
            </div>
    </div>
    </form>
    </div>
    </div>
    </div>
    </div>
    <!-- End Row -->

    <!-- modal1 -->
    <div class="modal fade text-left" id="Modal1" tabindex="-1" role="dialog" aria-labelledby="myModalLabel34"
        aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header justify-content-between">
                    <h3 class="modal-title" id="myModalLabel34"><?php echo e(trans('home.edit_category')); ?></h3>
                    <a type="button" class="close" data-bs-dismiss="modal" aria-bs-label="Close">
                        X
                    </a>
                </div>
                <form action="<?php echo e(route('dashboard.dashboard.projects.changeCategory', $project->id)); ?>"
                    method="post">
                    <?php echo csrf_field(); ?>
                    <div class="modal-body">
                        <div class="row">

                            <div class="form-group col-md-12">
                                <select class="form-control" data-trigger name="category_id" id="category" required>
                                    <option></option>
                                    <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($category->id); ?>"
                                            <?php echo e($project->category_id == $category->id ? 'selected' : ''); ?>>
                                            <?php echo e(app()->getLocale() == 'en' ? $category->name_en : $category->name_ar); ?>

                                        </option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                            </div>

                            <div class="form-group col-md-12 mt-3">
                                <button type="submit" class="btn btn-primary w-md"> <?php echo e(trans('home.save')); ?>

                                </button>
                            </div>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
    <?php $__env->startSection('script'); ?>
        <script>
            var token = "<?php echo e(csrf_token()); ?>";
            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': token
                }
            });

            // Enhanced file input preview
            $(document).on('change', 'input[name="image"]', function() {
                const file = this.files[0];
                const preview = $(this).closest('.enhanced-form-group').next().find('img');
                const noImageDiv = $(this).closest('.enhanced-form-group').next().find('.enhanced-no-image');

                console.log('Image file selected:', file);
                console.log('Preview element:', preview.length);
                console.log('No image div:', noImageDiv.length);

                if (file) {
                    console.log('File details:', {
                        name: file.name,
                        size: file.size,
                        type: file.type
                    });

                    // Validate file type
                    if (!file.type.startsWith('image/')) {
                        alert('يرجى اختيار ملف صورة صالح');
                        return;
                    }

                    // Validate file size (1MB max)
                    if (file.size > 1024 * 1024) {
                        alert('حجم الملف كبير جداً. الحد الأقصى 1MB');
                        return;
                    }

                    const reader = new FileReader();
                    reader.onload = function(e) {
                        console.log('File loaded successfully');
                        preview.attr('src', e.target.result);
                        preview.show();
                        if (noImageDiv.length) {
                            noImageDiv.hide();
                        }
                    };
                    reader.readAsDataURL(file);
                }
            });

            $(document).on('change', 'input[name="icon"]', function() {
                const file = this.files[0];
                const preview = $(this).closest('.enhanced-form-group').next().find('img');
                const noImageDiv = $(this).closest('.enhanced-form-group').next().find('.enhanced-no-image');

                console.log('Icon file selected:', file);
                console.log('Preview element:', preview.length);
                console.log('No image div:', noImageDiv.length);

                if (file) {
                    console.log('Icon file details:', {
                        name: file.name,
                        size: file.size,
                        type: file.type
                    });

                    // Validate file type
                    if (!file.type.startsWith('image/')) {
                        alert('يرجى اختيار ملف صورة صالح');
                        return;
                    }

                    // Validate file size (1MB max)
                    if (file.size > 1024 * 1024) {
                        alert('حجم الملف كبير جداً. الحد الأقصى 1MB');
                        return;
                    }

                    const reader = new FileReader();
                    reader.onload = function(e) {
                        console.log('Icon file loaded successfully');
                        preview.attr('src', e.target.result);
                        preview.show();
                        if (noImageDiv.length) {
                            noImageDiv.hide();
                        }
                    };
                    reader.readAsDataURL(file);
                }
            });

            // Debug function to check if elements exist
            console.log('Image input exists:', $('input[name="image"]').length);
            console.log('Icon input exists:', $('input[name="icon"]').length);

            // Handle project images multiple upload
            $(document).on('change', 'input[name="project_images[]"]', function() {
                const files = this.files;
                console.log('Project images selected:', files.length);
                console.log('Project images files:', files);

                if (files.length > 0) {
                    alert('تم اختيار ' + files.length + ' صورة بنجاح');
                }
            });

            // Initialize file inputs when page loads
            $(document).ready(function() {
                console.log('Page loaded, initializing file inputs...');

                // Check if file inputs exist
                if ($('input[name="image"]').length) {
                    console.log('Image input found');
                } else {
                    console.log('Image input NOT found');
                }

                if ($('input[name="icon"]').length) {
                    console.log('Icon input found');
                } else {
                    console.log('Icon input NOT found');
                }

                // Force show existing images
                $('.enhanced-image-preview img').each(function() {
                    if ($(this).attr('src') && $(this).attr('src') !== '') {
                        $(this).show();
                        $(this).closest('.enhanced-image-preview').find('.enhanced-no-image').hide();
                    }
                });

                // Add click handler to file input labels
                $('.file-input-label').on('click', function() {
                    const input = $(this).prev('input[type="file"]');
                    if (input.length) {
                        input.trigger('click');
                    }
                });
            });

            // Enhanced form validation
            $('form').on('submit', function(e) {
                console.log('Form submitting...');
                console.log('Form data:', new FormData(this));

                let isValid = true;

                $('.enhanced-form-group input[required], .enhanced-form-group textarea[required], .enhanced-form-group select[required]')
                    .each(function() {
                        if (!$(this).val()) {
                            $(this).addClass('is-invalid');
                            isValid = false;
                        } else {
                            $(this).removeClass('is-invalid').addClass('is-valid');
                        }
                    });

                // Check if files are selected
                const imageFile = $('input[name="image"]')[0].files[0];
                const iconFile = $('input[name="icon"]')[0].files[0];
                const projectImages = $('input[name="project_images[]"]')[0].files;

                console.log('Image file:', imageFile);
                console.log('Icon file:', iconFile);
                console.log('Project images:', projectImages);

                if (!isValid) {
                    e.preventDefault();
                    alert('<?php echo e(__('dashboard.please_fill_required_fields')); ?>');
                }
            });
        </script>
        <script src="https://cdn.jsdelivr.net/npm/sortablejs@1.15.0/Sortable.min.js"></script>
        <script>
            // Select all/unselect all button
            var allSelected = false;
            $('#select_all_btn').on('click', function() {
                allSelected = !allSelected;
                $('input.select_image_checkbox').prop('checked', allSelected);
                $(this).text(allSelected ? '<?php echo e(__('dashboard.unselect_all')); ?>' :
                    '<?php echo e(__('dashboard.select_all')); ?>');
            });
        </script>
        <script>
            // Delete selected images
            $('#delete_selected_btn').on('click', function(e) {
                e.preventDefault();
                var selected = [];
                $('input.select_image_checkbox:checked').each(function() {
                    selected.push($(this).val());
                });
                if (selected.length === 0) {
                    alert('Please select the images to delete');
                    return;
                }
                if (confirm('Are you sure you want to delete the selected images?')) {
                    $.ajax({
                        url: "<?php echo e(route('dashboard.dashboard.projects.deleteSelectedImages')); ?>",
                        method: 'POST',
                        data: {
                            image_ids: selected,
                            _token: token
                        },
                        success: function(data) {
                            if (data.success) {
                                location.reload();
                            } else {
                                alert(data.message || 'Error');
                            }
                        },
                        error: function(xhr) {
                            alert(xhr.responseJSON?.message || 'Error');
                        }
                    });
                }
            });
        </script>
        <script>
            $('.delete_all_img').on('click', function(e) {
                e.preventDefault();
                var projectId = $(this).data('id');
                if (confirm('<?php echo e(__('dashboard.confirm_delete_all_images')); ?>')) {
                    $.ajax({
                        url: "<?php echo e(route('dashboard.dashboard.projects.deleteAllImages')); ?>",
                        method: 'POST',
                        data: {
                            project_id: projectId,
                            _token: token
                        },
                        success: function(data) {
                            if (data.success) {
                                location.reload();
                            } else {
                                alert(data.message || 'حدث خطأ أثناء الحذف');
                            }
                        },
                        error: function(xhr) {
                            alert(xhr.responseJSON?.message || 'حدث خطأ أثناء الحذف');
                        }
                    });
                }
            });
        </script>
        <script src="https://cdnjs.cloudflare.com/ajax/libs/dropzone/4.0.1/dropzone.js"></script>

        <script type="text/javascript">
            Dropzone.autoDiscover = false;

            $("div.upload_images").dropzone({
                addRemoveLinks: true,
                acceptedFiles: ".jpeg,.jpg,.png,.gif,.svg.webp",
                maxFilesize: 3, // MB
                url: "<?php echo e(route('dashboard.dashboard.projects.uploadImages')); ?>",

                init: function() {
                    this.on("sending", function(file, xhr, formData) {
                        formData.append("projectId", "<?php echo e($project->id); ?>");
                    });
                },

                params: {
                    _token: token,
                    type: 'product_image',
                },

                removedfile: function(file) {
                    var fileName = file.name;
                    $.ajaxSetup({
                        headers: {
                            'X-CSRF-TOKEN': token
                        }
                    });
                    $.ajax({
                        type: 'POST',
                        url: "<?php echo e(route('dashboard.dashboard.projects.removeUploadImages')); ?>", // Use route instead of URL::to
                        data: {
                            type: 'project_image',
                            name: fileName,
                            request: 'delete'
                        },
                        success: function(data) {
                            console.log('success: ' + data);
                        }
                    });
                    var _ref;
                    return (_ref = file.previewElement) != null ? _ref.parentNode.removeChild(file.previewElement) :
                        void 0;
                }
            });

            Dropzone.options.myAwesomeDropzone = {
                paramName: "file",
                maxFilesize: 3, // MB
                accept: function(file, done) {
                    done();
                }
            };

            $('.delete_img_btn').on('click', function() {
                var image = $(this).data('image');
                var projectId = "<?php echo e($project->id); ?>";
                var btn = $(this);
                $.ajaxSetup({
                    headers: {
                        'X-CSRF-TOKEN': token
                    }
                });
                $.ajax({
                    url: "<?php echo e(route('dashboard.dashboard.projects.deleteImage')); ?>",
                    method: 'POST',
                    data: {
                        image: image,
                        projectId: projectId
                    },
                    success: function(data) {
                        location.href = "<?php echo e(route('dashboard.projects.edit', $project->id)); ?>";
                    }
                });
            });

            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': token
                }
            });

            // Enable drag & drop for images
            var sortableImages = document.getElementById('sortable-images');
            if (sortableImages) {
                new Sortable(sortableImages, {
                    animation: 150,
                    ghostClass: 'sortable-ghost',
                    chosenClass: 'sortable-chosen',
                    handle: '.drag-handle',
                    onEnd: function(evt) {
                        console.log('Order changed');
                    }
                });
            }

            // حفظ الترتيب الجديد
            $('#save_order_btn').on('click', function() {
                var imageIds = [];
                $('#sortable-images .sortable-container').each(function() {
                    imageIds.push($(this).data('id'));
                });

                if (imageIds.length === 0) {
                    alert('No images to save order');
                    return;
                }

                $.ajax({
                    url: "<?php echo e(route('dashboard.dashboard.projects.reorderImages')); ?>",
                    method: 'POST',
                    data: {
                        image_ids: imageIds,
                        _token: token
                    },
                    success: function(data) {
                        if (data.success) {
                            alert(data.message || 'Order saved successfully');
                        } else {
                            alert(data.message || 'Error saving order');
                        }
                    },
                    error: function(xhr) {
                        alert(xhr.responseJSON?.message || 'Error saving order');
                    }
                });
            });
        </script>
        <script>
            $('input[type="file"][name="project_images[]"]').on('change', function(e) {
                var maxSize = 1 * 1024 * 1024; // 1MB
                for (let i = 0; i < this.files.length; i++) {
                    if (this.files[i].size > maxSize) {
                        alert('Maximum image size is 1MB');
                        this.value = ""; // Clear the field
                        break;
                    }
                }
            });
        </script>
    <?php $__env->stopSection(); ?>

 <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginalcbd4b493d51bfac881dfb1e0f199e331)): ?>
<?php $attributes = $__attributesOriginalcbd4b493d51bfac881dfb1e0f199e331; ?>
<?php unset($__attributesOriginalcbd4b493d51bfac881dfb1e0f199e331); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalcbd4b493d51bfac881dfb1e0f199e331)): ?>
<?php $component = $__componentOriginalcbd4b493d51bfac881dfb1e0f199e331; ?>
<?php unset($__componentOriginalcbd4b493d51bfac881dfb1e0f199e331); ?>
<?php endif; ?>
<?php /**PATH /home/webtest3/public_html/mepicom/resources/views/Dashboard/Projects/edit.blade.php ENDPATH**/ ?>