<script>
    function initializeDataTable(tableId) {
        // تدمير الجدول إذا كان موجوداً
        if ($.fn.DataTable.isDataTable(tableId)) {
            $(tableId).DataTable().destroy();
        }

        // إزالة أي أزرار موجودة
        $('.dt-buttons').remove();

        // إعادة تهيئة الجدول
        var table = $(tableId).DataTable({
            dom: '<"row"<"col-md-6"B><"col-md-6"f>>' +
                '<"row"<"col-sm-12"tr>>' +
                '<"row"<"col-sm-12 col-md-5"i><"col-sm-12 col-md-7"p>>',
            buttons: [{
                    extend: 'copy',
                    className: 'btn-sm'
                },
                {
                    extend: 'excel',
                    className: 'btn-sm'
                },
                {
                    extend: 'pdf',
                    className: 'btn-sm'
                },
                {
                    extend: 'colvis',
                    className: 'btn-sm'
                }
            ],
            pageLength: 10,
            processing: true,
            columnDefs: [{
                targets: 0,
                orderable: false,
                searchable: false,
                className: 'text-center'
            }],
            order: [
                [1, 'desc']
            ],
            language: {
                "sProcessing": "Loading...",
                "sLengthMenu": "Show _MENU_ entries",
                "sZeroRecords": "No records found",
                "sInfo": "Showing _START_ to _END_ of _TOTAL_ entries",
                "sInfoEmpty": "Showing 0 to 0 of 0 entries",
                "sInfoFiltered": "(filtered from _MAX_ total entries)",
                "sInfoPostFix": "",
                "sSearch": "Search:",
                "sUrl": "",
                "oPaginate": {
                    "sFirst": "First",
                    "sPrevious": "Previous",
                    "sNext": "Next",
                    "sLast": "Last"
                },
                "oAria": {
                    "sSortAscending": ": Enable for ascending column sorting",
                    "sSortDescending": ": Enable for descending column sorting"
                }
            },
            drawCallback: function() {
                $('.dataTables_paginate > .pagination').addClass('pagination-rounded');

                // Re-enable checkboxes after table redraw
                setTimeout(function() {
                    // تفعيل زر تحديد الكل
                    $(document).off('change', '#checkAll').on('change', '#checkAll', function() {
                        var isChecked = $(this).is(':checked');
                        $('.check-inputs').prop('checked', isChecked);
                        updateCheckboxStyling();
                    });

                    // Enable individual checkboxes
                    $(document).off('change', '.check-inputs').on('change', '.check-inputs',
                        function() {
                            var totalCheckboxes = $('.check-inputs').length;
                            var checkedCheckboxes = $('.check-inputs:checked').length;
                            $('#checkAll').prop('checked', totalCheckboxes ===
                                checkedCheckboxes);
                            updateCheckboxStyling();
                        });

                    // Update checkbox styling
                    function updateCheckboxStyling() {
                        $('.check-inputs:checked').closest('.checkbox-enhanced').addClass(
                        'checked');
                        $('.check-inputs:not(:checked)').closest('.checkbox-enhanced').removeClass(
                            'checked');

                        if ($('#checkAll').is(':checked')) {
                            $('#checkAll').closest('.checkbox-enhanced').addClass('checked');
                        } else {
                            $('#checkAll').closest('.checkbox-enhanced').removeClass('checked');
                        }
                    }

                    updateCheckboxStyling();
                }, 100);
            }
        });

        // تحديث عرض الأزرار
        var buttonsContainer = table.buttons().container();
        if (buttonsContainer.length) {
            buttonsContainer.removeClass('btn-group').addClass('text-end');
            buttonsContainer.appendTo(tableId + '_wrapper .col-md-6:eq(0)');
        }

        return table;
    }
</script>
<?php /**PATH /home/webtest3/public_html/mepicom/resources/views/components/dashboard/partials/datatable.blade.php ENDPATH**/ ?>