<!--=============== Heder ============= -->
<div class="home position-relative z-2 px-lg-5">
    <header class="header z-3 px-lg-5">
        <!-- Top Bar -->
        <div class="top-bar position-relative pb-3">
            <div class="container d-none d-xl-flex justify-content-between align-items-center pb-5 pt-4 ">
                <div class="logo">
                    <a class="" href="{{ route('website.home') }}">
                        <img src="{{ Path::AppLogo('site_logo')}}" alt="Logo" width="150" />
                    </a>
                </div>
                <div class="contact-info d-flex gap-4 ">
                    <div class="phone d-flex align-items-center gap-3">
                        <i class="fas fa-phone  fs-4 text-main"></i>
                        <div>
                            @if(isset($headerPhone))
                            <h5 class="text-main ">{{ __('website.phone') }}</h5>
                            <span class=" text-main">
                                <a href="tel:{{ $headerPhone->code }}{{ $headerPhone->phone }}">{{ $headerPhone->phone }}</a>
                            </span>
                            @else
                            01123456789
                            @endif
                        </div>
                    </div>
                    <span class="fs-2">/</span>
                    <div class="email d-flex align-items-center gap-3">
                        <i class="fa-solid fa-at fs-4 text-main"></i>
                        <div>
                            <h5 class="text-main ">{{ __('website.email') }}</h5>
                            <span class=" text-main"><a href="mailto:{{ config('settings.site_email') ?? 'info@mepicom.com'}}">{{ config('settings.site_email') ?? 'info@mepicom.com'}}</a> </span>
                        </div>

                    </div>


                </div>
            </div>

            <!-- Navbar -->
            <nav class="navbar position-absolute justify-content-between navbar-expand-xl px-lg-5">
                <div
                    class="container d-flex flex-nowrap justify-content-between align-items-center py-3 rounded-3 w-100">
                    <a class="navbar-brand text-white" href="{{ route('website.home') }}">
                        <img src="{{Path::AppLogo('site_logo')}}" alt="Logo" width="130" />
                    </a>

                    <button class="navbar-toggler border-0" type="button" data-bs-toggle="offcanvas"
                        data-bs-target="#mobileMenu" aria-controls="mobileMenu" aria-label="Toggle navigation">
                        <i class="fa-solid fa-bars fs-3"></i>
                    </button>

                    <div class="collapse navbar-collapse gap-5" id="navbarSupportedContent">
                        <ul class="navbar-nav mx-auto mb-2 mb-lg-0 gap-4">
                            @if(isset($menus) && $menus->count() > 0)
                            <x-website.partials.mainmenu :menus="$menus" />
                            @endif
                        </ul>
                        <ul class="navbar-nav ms-auto mb-2 mb-lg-0 gap-4">
                            @if ($altLangLink)
                            <li class="nav-item">
                                <button type="button" class="btn btn-warning"><a href="{{ $altLangLink }}">{{ app()->getLocale() === 'ar' ? 'EN' : 'AR' }}</a></button>
                            </li>
                            @endif
                        </ul>
                    </div>
                </div>

                <!-- Mobile Offcanvas -->
                <div class="offcanvas offcanvas-end d-xl-none" id="mobileMenu" tabindex="-1"
                    aria-labelledby="mobileMenuLabel">
                    <div class="offcanvas-header">
                        <a class="navbar-brand w-100" href="{{ route('website.home') }}">
                            <img src="{{Path::AppLogo('site_logo')}}" alt="Logo" width="130" />
                        </a>
                        <button type="button" class="btn-close" data-bs-dismiss="offcanvas"
                            aria-label="Close"></button>
                    </div>
                    <div class="offcanvas-body px-4">
                        <ul class="navbar-nav">
                            @if(isset($menus) && $menus->count() > 0)
                            <x-website.partials.mainmenu :menus="$menus" />
                            @endif
                            @if (isset($altLangLink) && $altLangLink)
                            <li class="nav-item mt-4">
                                <button class="btn btn-warning fw-semibold"><a href="{{ $altLangLink }}">{{ app()->getLocale() === 'ar' ? 'EN' : 'AR' }}</a></button>
                            </li>
                            @endif
                        </ul>
                        <ul class="list-unstyled list-contact px-2 pt-5  rounded-4  ">
                            <li class="mb-4 pb-2 border-bottom">
                                <div class="d-flex align-items-center gap-3">
                                    <i class="fa-solid fa-at fs-3"></i>
                                    <div>
                                        <div class="fw-bold mb-1">{{__('website.email')}}</div>
                                        <a href="mailto:{{ config('settings.site_email') ?? 'info@mepicom.com'}}"
                                            class="text-decoration-none text-dark small">
                                            <a href="mailto:{{ config('settings.site_email') ?? 'info@mepicom.com'}}">{{ config('settings.site_email') ?? 'info@mepicom.com'}}</a>
                                        </a>
                                    </div>
                                </div>
                            </li>
                            <li class="mb-4 pb-2 border-bottom">
                                <div class="d-flex align-items-center gap-3">
                                    <i class="fa-solid fa-phone-volume fs-3"></i>
                                    <div>
                                        <div class="fw-bold mb-1">{{__('website.phone')}}</div>
                                        <span class="small d-block">
                                            @if(isset($headerPhone) && $headerPhone)
                                            <a href="tel:{{ $headerPhone->code }}{{ $headerPhone->phone }}" class="d-block mb-1">
                                                {{ $headerPhone->code }}{{ $headerPhone->phone }}
                                            </a>
                                            @else
                                            {{ config('settings.site_phone') ?? '01123456789'}}
                                            @endif
                                        </span>
                                    </div>
                                </div>
                            </li>
                            @foreach($site_addresses as $address)
                            <li>
                                <div class="d-flex align-items-center gap-3">
                                    <i class="fa-solid fa-globe fs-3"></i>
                                    <div>
                                        <div class="fw-bold mb-1">{{ $address->title }}</div>


                                        <span class="small d-block">
                                            <a href="{{ $address->map_link }}" target="_blank">{{ $address->address }}</a>
                                        </span>


                                    </div>
                                </div>
                            </li>
                            @endforeach
                            <li class="mt-4 pt-2 text-center d-flex gap-3 align-items-center icons-list-mobile">
                                <x-website.partials.social-media :socialMediaLinks="$socialMediaLinks" />
                            </li>
                        </ul>
            </nav>
        </div>
    </header>

</div>
<!-- Hero Slider -->

<!--=============== Heder ============= -->
<!-- Header Star -->
{{-- <header class="site-header header header-transparent style-2 header-toggle">
    <!-- Main Header -->
    <div class="sticky-header main-bar-wraper">
        <div class="main-bar clearfix">
            <div class="container-fluid clearfix inner-bar">
                <!-- Website Logo -->
                <div class="logo-header logo-dark">
                    <a href="{{ url('/') }}"><img src="{{ config('configrations.site_logo') }}" alt="logo"></a>
</div>
<!-- Nav Toggle Button -->
<button class="w3menu-toggler navicon" type="button" data-target="#W3Menu">
    <span></span>
    <span></span>
    <span></span>
</button>

<!-- Main Nav -->
<div class="menu-close fade-overlay"></div>
<div class="header-nav w3menu w3menu-start mo-left" id="W3Menu">
    <div class="logo-header logo-dark">
        <a href="{{ url('/') }}"><img src="{{ config('configrations.site_logo') }}"
                alt=""></a>
    </div>

    <ul class="nav navbar-nav">
        @if(isset($menus) && $menus->count() > 0)
        @foreach ($menus as $menu)
        <li><a href="{{ $menu->link }}">{{ $menu->name }}</a></li>
        @endforeach
        @endif
    </ul>
</div>
<!-- EXTRA NAV -->
<div class="extra-nav">
    <div class="extra-cell">
        <ul class="header-right">

            <li class="nav-item item-call">
                <div class="info-widget style-5">
                    <div class="widget-media">
                        <i class="feather icon-phone-call dz-ring-effect"></i>
                    </div>
                    <div class="widget-content">
                        <h6 class="title text-primary">Contact us?</h6>


                        @if(isset($site_addresses) && $site_addresses->count() > 0)
                        @php $firstAddress = $site_addresses->first(); @endphp
                        <a href="tel:{{ $firstAddress->phone ?? '' }}"
                            class="text-secondary">
                            {{ $firstAddress->phone ?? '' }}
                        </a>
                        @else
                        <a href="tel:{{ config('settings.site_phone') ?? '01123456789' }}"
                            class="text-secondary">
                            {{ config('settings.site_phone') ?? '01123456789' }}
                        </a>
                        @endif

                    </div>
                </div>
            </li>
        </ul>
    </div>
</div>

</div>
</div>
</div>
<!-- Main Header End -->

<!-- Sidebar -->
<div class="offcanvas dz-offcanvas offcanvas offcanvas-end" tabindex="-1" id="headerSidebar">
    <button type="button" class="btn-close m-t10 m-l10" data-bs-dismiss="offcanvas" aria-label="Close"></button>
    <div class="offcanvas-body">
        <div class="widget">
            <div class="sidebar-header m-b20">
                <a href="{{ url('/') }}"><img src="{{ config('configrations.site_logo') }}"
                        alt="/"></a>
            </div>
            <p>ClinicMaster is a modern and responsive Bootstrap HTML template designed for health and
                medical websites. Ideal for clinics, hospitals, and healthcare professionals seeking a
                professional online presence with an elegant and user-friendly design.</p>
        </div>

        <div class="widget">
            <div class="widget-title">
                <h4 class="title">Contact Us</h4>
            </div>
            <ul class="list-check">
                <li>25 Asmaa Fahmy - Cairo - EGY</li>
                <li><a href="mailto:email@domain.com" class="text-body">info@domain.com</a></li>
                <li><a href="tel:+11234567890" class="text-body">01001234567</a></li>
            </ul>
        </div>



        <div class="widget">
            <div class="widget-title">
                <h4 class="title">Follow Us</h4>
            </div>
            <div class="dz-social-icon style-1">
                <ul>
                    @if(config('settings.site_facebook'))
                    <li>
                        <a href="{{ config('settings.site_facebook') }}" target="_blank">
                            <i class="fa-brands fa-facebook-f"></i>
                        </a>
                    </li>
                    @endif
                    @if(config('settings.site_instagram'))
                    <li>
                        <a href="{{ config('settings.site_instagram') }}" target="_blank">
                            <i class="fa-brands fa-instagram"></i>
                        </a>
                    </li>
                    @endif
                    @if(config('settings.site_twitter'))
                    <li>
                        <a href="{{ config('settings.site_twitter') }}" target="_blank">
                            <i class="fa-brands fa-twitter"></i>
                        </a>
                    </li>
                    @endif
                    @if(config('settings.site_linkedin'))
                    <li>
                        <a href="{{ config('settings.site_linkedin') }}" target="_blank">
                            <i class="fa-brands fa-linkedin"></i>
                        </a>
                    </li>
                    @endif
                    @if(config('settings.site_youtube'))
                    <li>
                        <a href="{{ config('settings.site_youtube') }}" target="_blank">
                            <i class="fa-brands fa-youtube"></i>
                        </a>
                    </li>
                    @endif
                </ul>
            </div>
        </div>
    </div>
</div>
<!-- Sidebar -->
</header> --}}
<!-- Header End -->