<!--==========================Services==========================-->
<section class="product py-5 text-center">
    <div class="container mb-5">
        <div class="text-center mb-5" data-aos="fade-down" data-aos-duration="800">
            <div class="header-text">
                <h2 class="fw-bold fs-1">
                    <span class="transparent-text"> {{__('dashboard.products')}} </span>
                </h2>
            </div>
        </div>
        <ul class="nav nav-pills nav-tabs-custom mb-5 d-flex justify-content-center flex-xxl-nowrap" id="productsTab" role="tablist">
    @foreach ($categories as $index => $category)
        <li class="nav-item" role="presentation">
            <button class="nav-link @if($loop->first) active @endif text-nowrap" 
                id="{{$category->id}}-tab" 
                data-bs-toggle="tab"
                data-bs-target="#{{$category->id}}" 
                type="button" role="tab">
                {{$category->name }}
            </button>
        </li>
    @endforeach
</ul>

<div class="tab-content" id="productsTabContent">
    @foreach ($categories as $index => $category)
        <div class="tab-pane fade @if($loop->first) show active @endif" 
            id="{{$category->id}}" 
            role="tabpanel" 
            aria-labelledby="{{$category->id}}-tab">
            
            <div class="row g-4">
                @foreach($category->products as $product)
                    <div class="col-xl-3 col-md-6 wow fadeInUp" data-wow-delay="0.1s">
                        <div class="product-card">
                            <a >
                                <img src="{{$product->image_path}}" class="product-img shine-hover" alt="{{$product->name}}" />
                                <div class="product-body">
                                    <span class="product-category border border-primary text-primary text-opacity-75 px-3 py-1 rounded-2">
                                        {{$category->name}}
                                    </span>
                                    <h3 class="product-title pb-2">
                                        {{$product->name}}
                                    </h3>
                                    <p>
                                        {{$product->short_desc}}
                                    </p>
                                </div>
                            </a>
                        </div>
                    </div>
                @endforeach
            </div>
        </div>
    @endforeach
</div>

        <div class="text-center mt-5">
            <a href="{{ Path::AppUrl('products') }}" class="btn btn-warning py-3 px-4 wow fadeInUp" data-wow-delay="0.4s">{{ __('website.more_products') }}
                <i class="fas fa-arrow-right ms-2"></i></a>
        </div>
    </div>
</section>

<!-- Products Section Start -->
{{-- <section class="shop-section bg-cover section-padding" style="background-image: url('{{url('resources/assets/front/img/product/bg.jpg')}}');">
            <div class="shape-image">
                <img src="{{url('resources/assets/front/img/product/shape-2.png')}}" alt="img">
            </div>
            <div class="shape-image-2">
                <img src="{{url('resources/assets/front/img/product/shape-3.png')}}" alt="img">
            </div>
            <div class="array-button justify-content-center">
                <button class="array-prev"><i class="fa-regular fa-arrow-left-long"></i></button>
                <button class="array-next"><i class="fa-regular fa-arrow-right-long"></i></button>
            </div>
            <div class="container">
                @foreach ($projectsTitle as $title)
                <div class="section-title text-center">
                    <h6 class="wow fadeInUp">{{ \App\Helpers\Helper::getConfig('app_name', app()->getLocale()) }}</h6>
                    <h2 class="wow fadeInUp" data-wow-delay=".3s">
                        {{$title->title}} <br>
                        {{$title->title1}}
                    </h2>
                </div>
                @endforeach
                <div class="swiper shop-slider">
                    <div class="swiper-wrapper">
                        @foreach ($projects as $project)
                        <div class="swiper-slide">
                            <div class="shop-box-items">
                                <div class="shop-image">
                                    <img src="{{$project->image}}" alt="img">
                                </div>
                                <div class="shop-content">
                                    <h3><a href="{{$project->link}}">{{$project->name}}</a></h3>
                                </div>
                            </div>
                        </div>
                        @endforeach
                    </div>
                    
                </div>
                
                <h5 class="shop-bottom-title wow fadeInUp" data-wow-delay=".3s">
                    <a href="shop.html">{{ trans('home.More products') }}</a>
                </h5>
            </div>
        </section> --}}
<!--==========================Services==========================-->
