<!-- <================================================================= StartContactForm =======================================================> -->
<section class="contact pt-5">
  <div class="container py-5">
    @if (request()->segment(2) != 'contact-us')
    <div class="header-text mb-5">
      <h2 class="fw-bold fs-1 text-center">{{__('website.contact_us')}}</h2>
    </div>
    @endif
    <div class="row justify-content-center mb-5">
      <div class="col-12">
        <div class="row g-4">
          <div class="col-md-4">
            <div
              class="bg-light rounded-4 shadow-sm text-center py-4 px-2 h-100 d-flex flex-column align-items-center justify-content-center">
              <div class="mb-3 d-flex align-items-center justify-content-center">
                <i class="fa-solid fa-phone fs-2" style="color: #14489f"></i>
              </div>
              <div class="fw-semibold text-muted mb-1">{{__('website.contact_us')}}</div>
              @foreach($phones as $phone)
              <div class="fs-5 fw-bold" style="color: #14489f">
                <a href="tel:{{ $phone->code }}{{$phone->phone}}">{{$phone->phone}}</a>
              </div>
              @endforeach
            </div>
          </div>
          <div class="col-md-4">
            <div
              class="bg-light rounded-4 shadow-sm text-center py-4 px-2 h-100 d-flex flex-column align-items-center justify-content-center">
              <div class="mb-3 d-flex align-items-center justify-content-center">
                <i class="fa-solid fa-envelope fs-2" style="color: #14489f"></i>
              </div>
              <div class="fw-semibold text-muted mb-1">{{__('website.email')}}</div>
              <div class="fs-5 fw-bold" style="color: #14489f">
                <a href="mailto:{{config('settings.site_email')}}">{{config('settings.site_email')}}</a>
              </div>
            </div>
          </div>
          <div class="col-md-4">
            <div
              class="bg-light rounded-4 shadow-sm text-center py-4 px-2 h-100 d-flex flex-column align-items-center justify-content-center">
              <div class="mb-3 d-flex align-items-center justify-content-center">
                <i class="fa-solid fa-location-dot fs-2" style="color: #14489f"></i>
              </div>
              <div class="fw-semibold text-muted mb-1">
                {{__('website.address')}}
              </div>
              @foreach($site_addresses as $address)
              <div class="fs-5 fw-bold" style="color: #14489f">
                <a href="{{$address->map_link}}" target="_blank">{{$address->address}}</a>
              </div>
              @endforeach
            </div>
          </div>
        </div>
      </div>
    </div>
    <div class="row g-4">
      @foreach($site_addresses as $index => $address)
      @if($index == 0)
      <div class="col-lg-5 mb-lg-0">
        <div class="h-100 d-flex flex-column justify-content-stretch">
          <iframe
            src="{{$address->map_url}}"
            width="100%" height="100%" style="
                  border: 0;
                  min-height: 100%;
                  height: 100%;
                  display: block;
                " class="rounded-4 overflow-hidden shadow-lg h-100 w-100" allowfullscreen="" loading="lazy"
            referrerpolicy="no-referrer-when-downgrade"></iframe>
        </div>
      </div>
      @endif
      @endforeach

      <div class="col-lg-7">
        <div class="rounded-4 shadow-lg p-4 p-md-5 h-100 d-flex flex-column justify-content-center">
          <x-website.partials.contact-form />
        </div>
      </div>
    </div>
  </div>
</section>
<!-- <======================= EndContactForm =========================> -->